-------------------------------------------------------------------
--       Actel Proasic3l Vital Library
--       NAME: proasic3l.vhd
--       DATE: September 4, 2007
---------------------------------------------------------------------/

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.VITAL_Timing.all;

package COMPONENTS is

constant DefaultTimingChecksOn : Boolean := True;
constant DefaultXGenerationOn  : Boolean := False;
constant DefaultXon            : Boolean := False;
constant DefaultMsgOn          : Boolean := True;

component DYNCCC
   generic(
      VCOFREQUENCY      :  Real    := 0.0;
      f_CLKA_LOCK       :  Integer := 3; -- Number of CLKA pulses after which LOCK is raised

      TimingChecksOn    :  Boolean := True;
      InstancePath      :  STRING  := "*";
      Xon               :  Boolean := False;
      MsgOn             :  Boolean := True;

      tipd_CLKA         :  VitalDelayType01 := ( 0.000 ns, 0.000 ns );
      tipd_EXTFB        :  VitalDelayType01 := ( 0.000 ns, 0.000 ns );
      tipd_POWERDOWN    :  VitalDelayType01 := ( 0.000 ns, 0.000 ns );
      tipd_CLKB         :  VitalDelayType01 := ( 0.000 ns, 0.000 ns );
      tipd_CLKC         :  VitalDelayType01 := ( 0.000 ns, 0.000 ns );
      tipd_SDIN         :  VitalDelayType01 := ( 0.000 ns, 0.000 ns );
      tipd_SCLK         :  VitalDelayType01 := ( 0.000 ns, 0.000 ns );
      tipd_SSHIFT       :  VitalDelayType01 := ( 0.000 ns, 0.000 ns );
      tipd_SUPDATE      :  VitalDelayType01 := ( 0.000 ns, 0.000 ns );
      tipd_MODE         :  VitalDelayType01 := ( 0.000 ns, 0.000 ns );

      tpd_CLKA_GLA      :  VitalDelayType01 := ( 0.100 ns, 0.100 ns );
      tpd_EXTFB_GLA     :  VitalDelayType01 := ( 0.100 ns, 0.100 ns );
      tpd_POWERDOWN_GLA :  VitalDelayType01 := ( 0.100 ns, 0.100 ns );
      tpd_CLKA_GLB      :  VitalDelayType01 := ( 0.100 ns, 0.100 ns );
      tpd_EXTFB_GLB     :  VitalDelayType01 := ( 0.100 ns, 0.100 ns );
      tpd_POWERDOWN_GLB :  VitalDelayType01 := ( 0.100 ns, 0.100 ns );
      tpd_CLKA_GLC      :  VitalDelayType01 := ( 0.100 ns, 0.100 ns );
      tpd_EXTFB_GLC     :  VitalDelayType01 := ( 0.100 ns, 0.100 ns );
      tpd_POWERDOWN_GLC :  VitalDelayType01 := ( 0.100 ns, 0.100 ns );
      tpd_CLKA_YB       :  VitalDelayType01 := ( 0.100 ns, 0.100 ns );
      tpd_EXTFB_YB      :  VitalDelayType01 := ( 0.100 ns, 0.100 ns );
      tpd_POWERDOWN_YB  :  VitalDelayType01 := ( 0.100 ns, 0.100 ns );
      tpd_CLKA_YC       :  VitalDelayType01 := ( 0.100 ns, 0.100 ns );
      tpd_EXTFB_YC      :  VitalDelayType01 := ( 0.100 ns, 0.100 ns );
      tpd_POWERDOWN_YC  :  VitalDelayType01 := ( 0.100 ns, 0.100 ns );
      tpd_CLKA_LOCK     :  VitalDelayType01 := ( 0.100 ns, 0.100 ns );

      tpd_SCLK_SDOUT    : VitalDelayType01  := ( 0.100 ns, 0.100 ns );

      tsetup_SSHIFT_SCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_SSHIFT_SCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      thold_SSHIFT_SCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_SSHIFT_SCLK_negedge_posedge  : VitalDelayType := 0.000 ns;

      tsetup_SDIN_SCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_SDIN_SCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
      thold_SDIN_SCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_SDIN_SCLK_negedge_posedge    : VitalDelayType := 0.000 ns;

      tpw_SUPDATE_posedge                : VitalDelayType := 0.000 ns;
      tpw_SUPDATE_negedge                : VitalDelayType := 0.000 ns; 
      tpw_SCLK_posedge                   : VitalDelayType := 0.000 ns;
      tpw_SCLK_negedge                   : VitalDelayType := 0.000 ns

      ); 

   port (
          CLKA         : in    std_ulogic;
          EXTFB        : in    std_ulogic;
          POWERDOWN    : in    std_ulogic;
          CLKB         : in    std_ulogic;
          CLKC         : in    std_ulogic;
          SDIN         : in    std_ulogic;
          SCLK         : in    std_ulogic;
          SSHIFT       : in    std_ulogic;
          SUPDATE      : in    std_ulogic;
          MODE         : in    std_ulogic;
          OADIV0       : in    std_ulogic;
          OADIV1       : in    std_ulogic;
          OADIV2       : in    std_ulogic;
          OADIV3       : in    std_ulogic;
          OADIV4       : in    std_ulogic;
          OAMUX0       : in    std_ulogic;
          OAMUX1       : in    std_ulogic;
          OAMUX2       : in    std_ulogic;
          DLYGLA0      : in    std_ulogic;
          DLYGLA1      : in    std_ulogic;
          DLYGLA2      : in    std_ulogic;
          DLYGLA3      : in    std_ulogic;
          DLYGLA4      : in    std_ulogic;
          OBDIV0       : in    std_ulogic;
          OBDIV1       : in    std_ulogic;
          OBDIV2       : in    std_ulogic;
          OBDIV3       : in    std_ulogic;
          OBDIV4       : in    std_ulogic;
          OBMUX0       : in    std_ulogic;
          OBMUX1       : in    std_ulogic;
          OBMUX2       : in    std_ulogic;
          DLYYB0       : in    std_ulogic;
          DLYYB1       : in    std_ulogic;
          DLYYB2       : in    std_ulogic;
          DLYYB3       : in    std_ulogic;
          DLYYB4       : in    std_ulogic;
          DLYGLB0      : in    std_ulogic;
          DLYGLB1      : in    std_ulogic;
          DLYGLB2      : in    std_ulogic;
          DLYGLB3      : in    std_ulogic;
          DLYGLB4      : in    std_ulogic;
          OCDIV0       : in    std_ulogic;
          OCDIV1       : in    std_ulogic;
          OCDIV2       : in    std_ulogic;
          OCDIV3       : in    std_ulogic;
          OCDIV4       : in    std_ulogic;
          OCMUX0       : in    std_ulogic;
          OCMUX1       : in    std_ulogic;
          OCMUX2       : in    std_ulogic;
          DLYYC0       : in    std_ulogic;
          DLYYC1       : in    std_ulogic;
          DLYYC2       : in    std_ulogic;
          DLYYC3       : in    std_ulogic;
          DLYYC4       : in    std_ulogic;
          DLYGLC0      : in    std_ulogic;
          DLYGLC1      : in    std_ulogic;
          DLYGLC2      : in    std_ulogic;
          DLYGLC3      : in    std_ulogic;
          DLYGLC4      : in    std_ulogic;
          FINDIV0      : in    std_ulogic;
          FINDIV1      : in    std_ulogic;
          FINDIV2      : in    std_ulogic;
          FINDIV3      : in    std_ulogic;
          FINDIV4      : in    std_ulogic;
          FINDIV5      : in    std_ulogic;
          FINDIV6      : in    std_ulogic;
          FBDIV0       : in    std_ulogic;
          FBDIV1       : in    std_ulogic;
          FBDIV2       : in    std_ulogic;
          FBDIV3       : in    std_ulogic;
          FBDIV4       : in    std_ulogic;
          FBDIV5       : in    std_ulogic;
          FBDIV6       : in    std_ulogic;
          FBDLY0       : in    std_ulogic;
          FBDLY1       : in    std_ulogic;
          FBDLY2       : in    std_ulogic;
          FBDLY3       : in    std_ulogic;
          FBDLY4       : in    std_ulogic;
          FBSEL0       : in    std_ulogic;
          FBSEL1       : in    std_ulogic;
          XDLYSEL      : in    std_ulogic;
          VCOSEL0      : in    std_ulogic;
          VCOSEL1      : in    std_ulogic;
          VCOSEL2      : in    std_ulogic;
          GLA          : out   std_ulogic;
          LOCK         : out   std_ulogic;
          GLB          : out   std_ulogic;
          YB           : out   std_ulogic;
          GLC          : out   std_ulogic;
          YC           : out   std_ulogic;
          SDOUT        : out   std_ulogic
        );
end component;


component SHREG
   generic(
      tipd_SDIN      : VitalDelayType01 := ( 0.0 ns, 0.0 ns );
      tipd_SCLK      : VitalDelayType01 := ( 0.0 ns, 0.0 ns );
      tipd_SSHIFT    : VitalDelayType01 := ( 0.0 ns, 0.0 ns );
      tipd_SUPDATE   : VitalDelayType01 := ( 0.0 ns, 0.0 ns );

      TimingChecksOn : Boolean := True;
      InstancePath   : STRING  := "*";
      Xon            : Boolean := False;
      MsgOn          : Boolean := True);

   port(
      SDIN           :	in    STD_ULOGIC; -- Serial data input
      SCLK           :	in    STD_ULOGIC; -- Serial Clock signal
      SSHIFT         :	in    STD_ULOGIC; -- Serial shift enable signal 
      SUPDATE        :	in    STD_ULOGIC; -- Data in SR loaded into update latch
      SDOUT          :	out   STD_ULOGIC; -- Serial data output - data from LSB of SR shifted out
      SUPDATELATCH   :  out   STD_LOGIC_VECTOR ( 80 downto 0 )); -- Configuration bits
end component;

component PLL
  generic(
     VCOFREQUENCY      :  Real    := 0.0;
     f_CLKA_LOCK       :  Integer := 3; -- Number of CLKA pulses after which LOCK is raised

     TimingChecksOn    :  Boolean          := True;
     InstancePath      :  String           := "*";
     Xon               :  Boolean          := False;
     MsgOn             :  Boolean          := True;

     tipd_CLKA         :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_EXTFB        :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_POWERDOWN    :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OADIV0       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OADIV1       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OADIV2       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OADIV3       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OADIV4       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OAMUX0       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OAMUX1       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OAMUX2       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYGLA0      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYGLA1      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYGLA2      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYGLA3      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYGLA4      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OBDIV0       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OBDIV1       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OBDIV2       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OBDIV3       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OBDIV4       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OBMUX0       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OBMUX1       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OBMUX2       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYYB0       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYYB1       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYYB2       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYYB3       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYYB4       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYGLB0      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYGLB1      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYGLB2      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYGLB3      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYGLB4      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OCDIV0       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OCDIV1       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OCDIV2       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OCDIV3       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OCDIV4       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OCMUX0       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OCMUX1       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_OCMUX2       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYYC0       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYYC1       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYYC2       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYYC3       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYYC4       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYGLC0      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYGLC1      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYGLC2      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYGLC3      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_DLYGLC4      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_FINDIV0      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_FINDIV1      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_FINDIV2      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_FINDIV3      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_FINDIV4      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_FINDIV5      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_FINDIV6      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_FBDIV0       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_FBDIV1       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_FBDIV2       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_FBDIV3       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_FBDIV4       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_FBDIV5       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_FBDIV6       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_FBDLY0       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_FBDLY1       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_FBDLY2       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_FBDLY3       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_FBDLY4       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_FBSEL0       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_FBSEL1       :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_XDLYSEL      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_VCOSEL0      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_VCOSEL1      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );
     tipd_VCOSEL2      :  VitalDelayType01 := ( 0.000 ns,0.000 ns );

     tpd_CLKA_GLA      :  VitalDelayType01 := ( 0.100 ns, 0.100 ns);
     tpd_EXTFB_GLA     :  VitalDelayType01 := ( 0.100 ns, 0.100 ns);
     tpd_POWERDOWN_GLA :  VitalDelayType01 := ( 0.100 ns, 0.100 ns);
     tpd_CLKA_GLB      :  VitalDelayType01 := ( 0.100 ns, 0.100 ns);
     tpd_EXTFB_GLB     :  VitalDelayType01 := ( 0.100 ns, 0.100 ns);
     tpd_POWERDOWN_GLB :  VitalDelayType01 := ( 0.100 ns, 0.100 ns);
     tpd_CLKA_GLC      :  VitalDelayType01 := ( 0.100 ns, 0.100 ns);
     tpd_EXTFB_GLC     :  VitalDelayType01 := ( 0.100 ns, 0.100 ns);
     tpd_POWERDOWN_GLC :  VitalDelayType01 := ( 0.100 ns, 0.100 ns);
     tpd_CLKA_YB       :  VitalDelayType01 := ( 0.100 ns, 0.100 ns);
     tpd_EXTFB_YB      :  VitalDelayType01 := ( 0.100 ns, 0.100 ns);
     tpd_POWERDOWN_YB  :  VitalDelayType01 := ( 0.100 ns, 0.100 ns);
     tpd_CLKA_YC       :  VitalDelayType01 := ( 0.100 ns, 0.100 ns);
     tpd_EXTFB_YC      :  VitalDelayType01 := ( 0.100 ns, 0.100 ns);
     tpd_POWERDOWN_YC  :  VitalDelayType01 := ( 0.100 ns, 0.100 ns);
     tpd_CLKA_LOCK     :  VitalDelayType01 := ( 0.100 ns, 0.100 ns));


  port (
     CLKA         :  in    STD_ULOGIC;
     EXTFB        :  in    STD_ULOGIC;
     POWERDOWN    :  in    STD_ULOGIC;
     OADIV0       :  in    STD_ULOGIC;
     OADIV1       :  in    STD_ULOGIC;
     OADIV2       :  in    STD_ULOGIC;
     OADIV3       :  in    STD_ULOGIC;
     OADIV4       :  in    STD_ULOGIC;
     OAMUX0       :  in    STD_ULOGIC;
     OAMUX1       :  in    STD_ULOGIC;
     OAMUX2       :  in    STD_ULOGIC;
     DLYGLA0      :  in    STD_ULOGIC;
     DLYGLA1      :  in    STD_ULOGIC;
     DLYGLA2      :  in    STD_ULOGIC;
     DLYGLA3      :  in    STD_ULOGIC;
     DLYGLA4      :  in    STD_ULOGIC;
     OBDIV0       :  in    STD_ULOGIC;
     OBDIV1       :  in    STD_ULOGIC;
     OBDIV2       :  in    STD_ULOGIC;
     OBDIV3       :  in    STD_ULOGIC;
     OBDIV4       :  in    STD_ULOGIC;
     OBMUX0       :  in    STD_ULOGIC;
     OBMUX1       :  in    STD_ULOGIC;
     OBMUX2       :  in    STD_ULOGIC;
     DLYYB0       :  in    STD_ULOGIC;
     DLYYB1       :  in    STD_ULOGIC;
     DLYYB2       :  in    STD_ULOGIC;
     DLYYB3       :  in    STD_ULOGIC;
     DLYYB4       :  in    STD_ULOGIC;
     DLYGLB0      :  in    STD_ULOGIC;
     DLYGLB1      :  in    STD_ULOGIC;
     DLYGLB2      :  in    STD_ULOGIC;
     DLYGLB3      :  in    STD_ULOGIC;
     DLYGLB4      :  in    STD_ULOGIC;
     OCDIV0       :  in    STD_ULOGIC;
     OCDIV1       :  in    STD_ULOGIC;
     OCDIV2       :  in    STD_ULOGIC;
     OCDIV3       :  in    STD_ULOGIC;
     OCDIV4       :  in    STD_ULOGIC;
     OCMUX0       :  in    STD_ULOGIC;
     OCMUX1       :  in    STD_ULOGIC;
     OCMUX2       :  in    STD_ULOGIC;
     DLYYC0       :  in    STD_ULOGIC;
     DLYYC1       :  in    STD_ULOGIC;
     DLYYC2       :  in    STD_ULOGIC;
     DLYYC3       :  in    STD_ULOGIC;
     DLYYC4       :  in    STD_ULOGIC;
     DLYGLC0      :  in    STD_ULOGIC;
     DLYGLC1      :  in    STD_ULOGIC;
     DLYGLC2      :  in    STD_ULOGIC;
     DLYGLC3      :  in    STD_ULOGIC;
     DLYGLC4      :  in    STD_ULOGIC;
     FINDIV0      :  in    STD_ULOGIC;
     FINDIV1      :  in    STD_ULOGIC;
     FINDIV2      :  in    STD_ULOGIC;
     FINDIV3      :  in    STD_ULOGIC;
     FINDIV4      :  in    STD_ULOGIC;
     FINDIV5      :  in    STD_ULOGIC;
     FINDIV6      :  in    STD_ULOGIC;
     FBDIV0       :  in    STD_ULOGIC;
     FBDIV1       :  in    STD_ULOGIC;
     FBDIV2       :  in    STD_ULOGIC;
     FBDIV3       :  in    STD_ULOGIC;
     FBDIV4       :  in    STD_ULOGIC;
     FBDIV5       :  in    STD_ULOGIC;
     FBDIV6       :  in    STD_ULOGIC;
     FBDLY0       :  in    STD_ULOGIC;
     FBDLY1       :  in    STD_ULOGIC;
     FBDLY2       :  in    STD_ULOGIC;
     FBDLY3       :  in    STD_ULOGIC;
     FBDLY4       :  in    STD_ULOGIC;
     FBSEL0       :  in    STD_ULOGIC;
     FBSEL1       :  in    STD_ULOGIC;
     XDLYSEL      :  in    STD_ULOGIC;
     VCOSEL0      :  in    STD_ULOGIC;
     VCOSEL1      :  in    STD_ULOGIC;
     VCOSEL2      :  in    STD_ULOGIC;
     GLA          :  out   STD_ULOGIC;
     LOCK         :  out   STD_ULOGIC;
     GLB          :  out   STD_ULOGIC;
     YB           :  out   STD_ULOGIC;
     GLC          :  out   STD_ULOGIC;
     YC           :  out   STD_ULOGIC);
end component;

--component CLKDIVDLY1
--     generic(
--        TimingChecksOn: Boolean := True;
--        InstancePath: STRING := "*";
--        Xon: Boolean := False;
--        MsgOn: Boolean := True;
--        tipd_CLK         :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_ODIV0       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_ODIV1       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_ODIV2       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_ODIV3       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_ODIV4       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_DLYY0       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_DLYY1       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_DLYY2       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_DLYY3       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_DLYY4       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_DLYGL0       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_DLYGL1       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_DLYGL2       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_DLYGL3       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_DLYGL4       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tpd_CLK_GL        :  VitalDelayType01 := (  0.1 ns,0.1 ns );
--        tpd_CLK_Y         :  VitalDelayType01 := (  0.1 ns,0.1 ns ));
--
--
--     port (
--        CLK         : in    STD_ULOGIC;
--        ODIV0       : in    STD_ULOGIC;
--        ODIV1       : in    STD_ULOGIC;
--        ODIV2       : in    STD_ULOGIC;
--        ODIV3       : in    STD_ULOGIC;
--        ODIV4       : in    STD_ULOGIC;
--        DLYY0       : in    STD_ULOGIC;
--        DLYY1       : in    STD_ULOGIC;
--        DLYY2       : in    STD_ULOGIC;
--        DLYY3       : in    STD_ULOGIC;
--        DLYY4       : in    STD_ULOGIC;
--        DLYGL0       : in    STD_ULOGIC;
--        DLYGL1       : in    STD_ULOGIC;
--        DLYGL2       : in    STD_ULOGIC;
--        DLYGL3       : in    STD_ULOGIC;
--        DLYGL4       : in    STD_ULOGIC;
--        GL           : out   STD_ULOGIC;
--        Y            : out   STD_ULOGIC);
-- 
--end component;

--component CLKDIVDLY
--     generic(
--        TimingChecksOn: Boolean := True;
--        InstancePath: STRING := "*";
--        Xon: Boolean := False;
--        MsgOn: Boolean := True;
--        tipd_CLK         :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_ODIV0       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_ODIV1       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_ODIV2       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_ODIV3       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_ODIV4       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_DLYGL0       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_DLYGL1       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_DLYGL2       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_DLYGL3       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tipd_DLYGL4       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
--        tpd_CLK_GL        :  VitalDelayType01 := (  0.1 ns,0.1 ns ));
--
--     port (
--        CLK         : in    STD_ULOGIC;
--        ODIV0       : in    STD_ULOGIC;
--        ODIV1       : in    STD_ULOGIC;
--        ODIV2       : in    STD_ULOGIC;
--        ODIV3       : in    STD_ULOGIC;
--        ODIV4       : in    STD_ULOGIC;
--        DLYGL0       : in    STD_ULOGIC;
--        DLYGL1       : in    STD_ULOGIC;
--        DLYGL2       : in    STD_ULOGIC;
--        DLYGL3       : in    STD_ULOGIC;
--        DLYGL4       : in    STD_ULOGIC;
--        GL           : out   STD_ULOGIC
--          );
--
--end component;

component CLKDLY
    generic(
        TimingChecksOn: Boolean := True;
        InstancePath: STRING := "*";
        Xon: Boolean := False;
        MsgOn: Boolean := True;
        tipd_CLK         :  VitalDelayType01 := (  0.0 ns,0.0 ns );
        tipd_DLYGL0       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
        tipd_DLYGL1       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
        tipd_DLYGL2       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
        tipd_DLYGL3       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
        tipd_DLYGL4       :  VitalDelayType01 := (  0.0 ns,0.0 ns );
        tpd_CLK_GL        :  VitalDelayType01 := (  0.1 ns,0.1 ns )
        );

     port (
        CLK         : in    STD_ULOGIC;
        DLYGL0       : in    STD_ULOGIC;
        DLYGL1       : in    STD_ULOGIC;
        DLYGL2       : in    STD_ULOGIC;
        DLYGL3       : in    STD_ULOGIC;
        DLYGL4       : in    STD_ULOGIC;
        GL           : out   STD_ULOGIC
          );

end component;

component CLKDLYIO
    generic(
        TimingChecksOn    : Boolean := True;
        InstancePath      : STRING  := "*";
        Xon               : Boolean := False;
        MsgOn             : Boolean := True;
        tipd_CLK          : VitalDelayType01  := (  0.0 ns,0.0 ns );
        tipd_DLYGL0       : VitalDelayType01  := (  0.0 ns,0.0 ns );
        tipd_DLYGL1       : VitalDelayType01  := (  0.0 ns,0.0 ns );
        tipd_DLYGL2       : VitalDelayType01  := (  0.0 ns,0.0 ns );
        tipd_DLYGL3       : VitalDelayType01  := (  0.0 ns,0.0 ns );
        tipd_DLYGL4       : VitalDelayType01  := (  0.0 ns,0.0 ns );
        tpd_CLK_GL        : VitalDelayType01  := (  0.1 ns,0.1 ns )
        ); 

    port (
        CLK          : in    STD_ULOGIC;
        DLYGL0       : in    STD_ULOGIC;
        DLYGL1       : in    STD_ULOGIC;
        DLYGL2       : in    STD_ULOGIC;
        DLYGL3       : in    STD_ULOGIC;
        DLYGL4       : in    STD_ULOGIC;
        GL           : out   STD_ULOGIC
        );
end component;

component CLKDLYINT
    generic(
        TimingChecksOn    : Boolean := True;
        InstancePath      : STRING  := "*";
        Xon               : Boolean := False;
        MsgOn             : Boolean := True;
        tipd_CLK          : VitalDelayType01  := (  0.0 ns,0.0 ns );
        tipd_DLYGL0       : VitalDelayType01  := (  0.0 ns,0.0 ns );
        tipd_DLYGL1       : VitalDelayType01  := (  0.0 ns,0.0 ns );
        tipd_DLYGL2       : VitalDelayType01  := (  0.0 ns,0.0 ns );
        tipd_DLYGL3       : VitalDelayType01  := (  0.0 ns,0.0 ns );
        tipd_DLYGL4       : VitalDelayType01  := (  0.0 ns,0.0 ns );
        tpd_CLK_GL        : VitalDelayType01  := (  0.1 ns,0.1 ns )
        );
    port (
        CLK          : in    STD_ULOGIC;
        DLYGL0       : in    STD_ULOGIC;
        DLYGL1       : in    STD_ULOGIC;
        DLYGL2       : in    STD_ULOGIC;
        DLYGL3       : in    STD_ULOGIC;
        DLYGL4       : in    STD_ULOGIC;
        GL           : out   STD_ULOGIC
        );
end component;

component RAM4K9
   generic (
      TimingChecksOn   : Boolean := True;
      InstancePath     : String  := "*";
      Xon              : Boolean := False;
      MsgOn            : Boolean := True;
      MEMORYFILE       : String  := "";
      WARNING_MSGS_ON  : Boolean := True;
           
      tipd_ADDRA11     : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRA10     : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRA9      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRA8      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRA7      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRA6      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRA5      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRA4      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRA3      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRA2      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRA1      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRA0      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRB11     : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRB10     : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRB9      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRB8      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRB7      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRB6      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRB5      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRB4      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRB3      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRB2      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRB1      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDRB0      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DINA8       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DINA7       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DINA6       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DINA5       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DINA4       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DINA3       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DINA2       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DINA1       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DINA0       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DINB8       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DINB7       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DINB6       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DINB5       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DINB4       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DINB3       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DINB2       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DINB1       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DINB0       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WIDTHA1     : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WIDTHA0     : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WIDTHB1     : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WIDTHB0     : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PIPEA       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PIPEB       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WMODEA      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WMODEB      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_BLKA        : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_BLKB        : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WENA        : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WENB        : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLKA        : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLKB        : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RESET       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLKA_DOUTA8  : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_CLKA_DOUTA7  : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_CLKA_DOUTA6  : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_CLKA_DOUTA5  : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_CLKA_DOUTA4  : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_CLKA_DOUTA3  : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_CLKA_DOUTA2  : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_CLKA_DOUTA1  : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_CLKA_DOUTA0  : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_CLKB_DOUTB8  : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_CLKB_DOUTB7  : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_CLKB_DOUTB6  : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_CLKB_DOUTB5  : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_CLKB_DOUTB4  : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_CLKB_DOUTB3  : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_CLKB_DOUTB2  : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_CLKB_DOUTB1  : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_CLKB_DOUTB0  : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_RESET_DOUTA8 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_RESET_DOUTA7 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_RESET_DOUTA6 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_RESET_DOUTA5 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_RESET_DOUTA4 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_RESET_DOUTA3 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_RESET_DOUTA2 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_RESET_DOUTA1 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_RESET_DOUTA0 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_RESET_DOUTB8 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_RESET_DOUTB7 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_RESET_DOUTB6 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_RESET_DOUTB5 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_RESET_DOUTB4 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_RESET_DOUTB3 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_RESET_DOUTB2 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_RESET_DOUTB1 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_RESET_DOUTB0 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tsetup_DINA8_CLKA_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINA8_CLKA_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINA7_CLKA_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINA7_CLKA_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINA6_CLKA_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINA6_CLKA_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINA5_CLKA_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINA5_CLKA_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINA4_CLKA_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINA4_CLKA_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINA3_CLKA_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINA3_CLKA_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINA2_CLKA_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINA2_CLKA_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINA1_CLKA_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINA1_CLKA_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINA0_CLKA_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINA0_CLKA_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINB8_CLKB_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINB8_CLKB_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINB7_CLKB_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINB7_CLKB_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINB6_CLKB_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINB6_CLKB_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINB5_CLKB_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINB5_CLKB_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINB4_CLKB_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINB4_CLKB_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINB3_CLKB_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINB3_CLKB_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINB2_CLKB_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINB2_CLKB_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINB1_CLKB_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINB1_CLKB_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINB0_CLKB_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_DINB0_CLKB_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_DINA8_CLKA_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINA8_CLKA_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINA7_CLKA_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINA7_CLKA_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINA6_CLKA_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINA6_CLKA_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINA5_CLKA_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINA5_CLKA_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINA4_CLKA_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINA4_CLKA_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINA3_CLKA_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINA3_CLKA_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINA2_CLKA_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINA2_CLKA_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINA1_CLKA_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINA1_CLKA_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINA0_CLKA_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINA0_CLKA_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINB8_CLKB_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINB8_CLKB_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINB7_CLKB_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINB7_CLKB_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINB6_CLKB_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINB6_CLKB_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINB5_CLKB_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINB5_CLKB_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINB4_CLKB_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINB4_CLKB_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINB3_CLKB_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINB3_CLKB_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINB2_CLKB_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINB2_CLKB_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINB1_CLKB_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINB1_CLKB_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINB0_CLKB_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DINB0_CLKB_negedge_posedge     : VitalDelayType := 0.000 ns;
      tsetup_ADDRA11_CLKA_posedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_ADDRA11_CLKA_negedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_ADDRA10_CLKA_posedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_ADDRA10_CLKA_negedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_ADDRA9_CLKA_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRA9_CLKA_negedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRA8_CLKA_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRA8_CLKA_negedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRA7_CLKA_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRA7_CLKA_negedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRA6_CLKA_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRA6_CLKA_negedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRA5_CLKA_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRA5_CLKA_negedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRA4_CLKA_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRA4_CLKA_negedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRA3_CLKA_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRA3_CLKA_negedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRA2_CLKA_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRA2_CLKA_negedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRA1_CLKA_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRA1_CLKA_negedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRA0_CLKA_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRA0_CLKA_negedge_posedge   : VitalDelayType := 0.000 ns;
      thold_ADDRA11_CLKA_posedge_posedge   : VitalDelayType := 0.000 ns;
      thold_ADDRA11_CLKA_negedge_posedge   : VitalDelayType := 0.000 ns;
      thold_ADDRA10_CLKA_posedge_posedge   : VitalDelayType := 0.000 ns;
      thold_ADDRA10_CLKA_negedge_posedge   : VitalDelayType := 0.000 ns;
      thold_ADDRA9_CLKA_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRA9_CLKA_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRA8_CLKA_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRA8_CLKA_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRA7_CLKA_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRA7_CLKA_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRA6_CLKA_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRA6_CLKA_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRA5_CLKA_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRA5_CLKA_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRA4_CLKA_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRA4_CLKA_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRA3_CLKA_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRA3_CLKA_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRA2_CLKA_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRA2_CLKA_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRA1_CLKA_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRA1_CLKA_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRA0_CLKA_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRA0_CLKA_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_ADDRB11_CLKB_posedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_ADDRB11_CLKB_negedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_ADDRB10_CLKB_posedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_ADDRB10_CLKB_negedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_ADDRB9_CLKB_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRB9_CLKB_negedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRB8_CLKB_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRB8_CLKB_negedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRB7_CLKB_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRB7_CLKB_negedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRB6_CLKB_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRB6_CLKB_negedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRB5_CLKB_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRB5_CLKB_negedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRB4_CLKB_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRB4_CLKB_negedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRB3_CLKB_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRB3_CLKB_negedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRB2_CLKB_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRB2_CLKB_negedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRB1_CLKB_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRB1_CLKB_negedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRB0_CLKB_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_ADDRB0_CLKB_negedge_posedge   : VitalDelayType := 0.000 ns;
      thold_ADDRB11_CLKB_posedge_posedge   : VitalDelayType := 0.000 ns;
      thold_ADDRB11_CLKB_negedge_posedge   : VitalDelayType := 0.000 ns;
      thold_ADDRB10_CLKB_posedge_posedge   : VitalDelayType := 0.000 ns;
      thold_ADDRB10_CLKB_negedge_posedge   : VitalDelayType := 0.000 ns;
      thold_ADDRB9_CLKB_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRB9_CLKB_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRB8_CLKB_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRB8_CLKB_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRB7_CLKB_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRB7_CLKB_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRB6_CLKB_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRB6_CLKB_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRB5_CLKB_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRB5_CLKB_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRB4_CLKB_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRB4_CLKB_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRB3_CLKB_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRB3_CLKB_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRB2_CLKB_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRB2_CLKB_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRB1_CLKB_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRB1_CLKB_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRB0_CLKB_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_ADDRB0_CLKB_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_WENA_CLKA_negedge_posedge     : VitalDelayType := 0.000 ns;
      tsetup_WENA_CLKA_posedge_posedge     : VitalDelayType := 0.000 ns;
      tsetup_BLKA_CLKA_negedge_posedge     : VitalDelayType := 0.000 ns;
      tsetup_BLKA_CLKA_posedge_posedge     : VitalDelayType := 0.000 ns;
      tsetup_WMODEA_CLKA_negedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_WMODEA_CLKA_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_PIPEA_CLKA_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_PIPEA_CLKA_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_WENA_CLKA_negedge_posedge      : VitalDelayType := 0.000 ns;
      thold_WENA_CLKA_posedge_posedge      : VitalDelayType := 0.000 ns;
      thold_BLKA_CLKA_negedge_posedge      : VitalDelayType := 0.000 ns;
      thold_BLKA_CLKA_posedge_posedge      : VitalDelayType := 0.000 ns;
      thold_WMODEA_CLKA_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_WMODEA_CLKA_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_PIPEA_CLKA_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_PIPEA_CLKA_posedge_posedge     : VitalDelayType := 0.000 ns;
      tsetup_WENB_CLKB_negedge_posedge     : VitalDelayType := 0.000 ns;
      tsetup_WENB_CLKB_posedge_posedge     : VitalDelayType := 0.000 ns;
      tsetup_BLKB_CLKB_negedge_posedge     : VitalDelayType := 0.000 ns;
      tsetup_BLKB_CLKB_posedge_posedge     : VitalDelayType := 0.000 ns;
      tsetup_WMODEB_CLKB_negedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_WMODEB_CLKB_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_PIPEB_CLKB_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_PIPEB_CLKB_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_WIDTHB1_CLKB_negedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WIDTHB1_CLKB_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WIDTHB1_CLKB_negedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WIDTHB1_CLKB_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_WIDTHB0_CLKB_negedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WIDTHB0_CLKB_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WIDTHB0_CLKB_negedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WIDTHB0_CLKB_posedge_posedge   : VitalDelayType := 0.000 ns;

      tsetup_WIDTHA1_CLKA_negedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WIDTHA1_CLKA_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WIDTHA1_CLKA_negedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WIDTHA1_CLKA_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_WIDTHA0_CLKA_negedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WIDTHA0_CLKA_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WIDTHA0_CLKA_negedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WIDTHA0_CLKA_posedge_posedge   : VitalDelayType := 0.000 ns;

      thold_WENB_CLKB_negedge_posedge      : VitalDelayType := 0.000 ns;
      thold_WENB_CLKB_posedge_posedge      : VitalDelayType := 0.000 ns;
      thold_BLKB_CLKB_negedge_posedge      : VitalDelayType := 0.000 ns;
      thold_BLKB_CLKB_posedge_posedge      : VitalDelayType := 0.000 ns;
      thold_WMODEB_CLKB_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_WMODEB_CLKB_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_PIPEB_CLKB_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_PIPEB_CLKB_posedge_posedge     : VitalDelayType := 0.000 ns;
      
      tpw_CLKA_posedge                     : VitalDelayType := 0.000 ns;
      tpw_CLKA_negedge                     : VitalDelayType := 0.000 ns;
      tpw_CLKB_posedge                     : VitalDelayType := 0.000 ns;
      tpw_CLKB_negedge                     : VitalDelayType := 0.000 ns;
      trecovery_RESET_CLKA_posedge_posedge : VitalDelayType := 0.000 ns;
      trecovery_RESET_CLKB_posedge_posedge : VitalDelayType := 0.000 ns;
      thold_RESET_CLKA_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_RESET_CLKB_posedge_posedge     : VitalDelayType := 0.000 ns;
      tpw_RESET_negedge                    : VitalDelayType := 0.000 ns
     );

   port (
      ADDRA11       : IN STD_ULOGIC ;
      ADDRA10       : IN STD_ULOGIC ;
      ADDRA9        : IN STD_ULOGIC ;
      ADDRA8        : IN STD_ULOGIC ;
      ADDRA7        : IN STD_ULOGIC ;
      ADDRA6        : IN STD_ULOGIC ;
      ADDRA5        : IN STD_ULOGIC ;
      ADDRA4        : IN STD_ULOGIC ;
      ADDRA3        : IN STD_ULOGIC ;
      ADDRA2        : IN STD_ULOGIC ;
      ADDRA1        : IN STD_ULOGIC ;
      ADDRA0        : IN STD_ULOGIC ;
      ADDRB11       : IN STD_ULOGIC ;
      ADDRB10       : IN STD_ULOGIC ;
      ADDRB9        : IN STD_ULOGIC ;
      ADDRB8        : IN STD_ULOGIC ;
      ADDRB7        : IN STD_ULOGIC ;
      ADDRB6        : IN STD_ULOGIC ;
      ADDRB5        : IN STD_ULOGIC ;
      ADDRB4        : IN STD_ULOGIC ;
      ADDRB3        : IN STD_ULOGIC ;
      ADDRB2        : IN STD_ULOGIC ;
      ADDRB1        : IN STD_ULOGIC ;
      ADDRB0        : IN STD_ULOGIC ;
      DINA8         : IN STD_ULOGIC ;
      DINA7         : IN STD_ULOGIC ;
      DINA6         : IN STD_ULOGIC ;
      DINA5         : IN STD_ULOGIC ;
      DINA4         : IN STD_ULOGIC ;
      DINA3         : IN STD_ULOGIC ;
      DINA2         : IN STD_ULOGIC ;
      DINA1         : IN STD_ULOGIC ;
      DINA0         : IN STD_ULOGIC ; 
      DINB8         : IN STD_ULOGIC ;
      DINB7         : IN STD_ULOGIC ;
      DINB6         : IN STD_ULOGIC ;
      DINB5         : IN STD_ULOGIC ;
      DINB4         : IN STD_ULOGIC ;
      DINB3         : IN STD_ULOGIC ;
      DINB2         : IN STD_ULOGIC ;
      DINB1         : IN STD_ULOGIC ;
      DINB0         : IN STD_ULOGIC ;
      WIDTHA1       : IN STD_ULOGIC ;
      WIDTHA0       : IN STD_ULOGIC ;
      WIDTHB1       : IN STD_ULOGIC ;
      WIDTHB0       : IN STD_ULOGIC ;
      PIPEA         : IN STD_ULOGIC ;
      PIPEB         : IN STD_ULOGIC ;
      WMODEA        : IN STD_ULOGIC ;
      WMODEB        : IN STD_ULOGIC ;
      BLKA          : IN STD_ULOGIC ;
      BLKB          : IN STD_ULOGIC ;
      WENA          : IN STD_ULOGIC ;
      WENB          : IN STD_ULOGIC ;
      CLKA          : IN STD_ULOGIC ;
      CLKB          : IN STD_ULOGIC ;
      RESET         : IN STD_ULOGIC ;
      DOUTA8        : OUT STD_ULOGIC ;
      DOUTA7        : OUT STD_ULOGIC ;
      DOUTA6        : OUT STD_ULOGIC ;
      DOUTA5        : OUT STD_ULOGIC ;
      DOUTA4        : OUT STD_ULOGIC ;
      DOUTA3        : OUT STD_ULOGIC ;
      DOUTA2        : OUT STD_ULOGIC ;
      DOUTA1        : OUT STD_ULOGIC ;
      DOUTA0        : OUT STD_ULOGIC ;
      DOUTB8        : OUT STD_ULOGIC ;
      DOUTB7        : OUT STD_ULOGIC ;
      DOUTB6        : OUT STD_ULOGIC ;
      DOUTB5        : OUT STD_ULOGIC ;
      DOUTB4        : OUT STD_ULOGIC ;
      DOUTB3        : OUT STD_ULOGIC ;
      DOUTB2        : OUT STD_ULOGIC ;
      DOUTB1        : OUT STD_ULOGIC ;
      DOUTB0        : OUT STD_ULOGIC
     );

end component;


component RAM512X18
   generic (
      TimingChecksOn  : Boolean := True;
      InstancePath    : String  := "*";
      Xon             : Boolean := False;
      MsgOn           : Boolean := True;
      MEMORYFILE      : String  := "";
      WARNING_MSGS_ON : Boolean := True;

      tipd_RADDR8    : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RADDR7    : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RADDR6    : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RADDR5    : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RADDR4    : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RADDR3    : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RADDR2    : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RADDR1    : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RADDR0    : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WADDR8    : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WADDR7    : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WADDR6    : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WADDR5    : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WADDR4    : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WADDR3    : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WADDR2    : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WADDR1    : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WADDR0    : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD17      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD16      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD15      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD14      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD13      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD12      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD11      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD10      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD9       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD8       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD7       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD6       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD5       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD4       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD3       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD2       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD1       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD0       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WW1       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WW0       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RW1       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RW0       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WEN       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCLK      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_REN       : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RCLK      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PIPE      : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RESET     : VitalDelayType01 := (0.000 ns, 0.000 ns);
      
      tpd_RCLK_RD17  : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_RCLK_RD16  : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RCLK_RD15  : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RCLK_RD14  : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RCLK_RD13  : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RCLK_RD12  : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RCLK_RD11  : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RCLK_RD10  : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RCLK_RD9   : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RCLK_RD8   : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RCLK_RD7   : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RCLK_RD6   : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RCLK_RD5   : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RCLK_RD4   : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RCLK_RD3   : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RCLK_RD2   : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RCLK_RD1   : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RCLK_RD0   : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RESET_RD17 : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RESET_RD16 : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RESET_RD15 : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RESET_RD14 : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RESET_RD13 : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RESET_RD12 : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RESET_RD11 : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RESET_RD10 : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RESET_RD9  : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RESET_RD8  : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RESET_RD7  : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RESET_RD6  : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RESET_RD5  : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RESET_RD4  : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RESET_RD3  : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RESET_RD2  : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RESET_RD1  : VitalDelayType01 := (0.100 ns, 0.100 ns); 
      tpd_RESET_RD0  : VitalDelayType01 := (0.100 ns, 0.100 ns);
      
      tsetup_WD17_WCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WD17_WCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WD16_WCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WD16_WCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WD15_WCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WD15_WCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WD14_WCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WD14_WCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WD13_WCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WD13_WCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WD12_WCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WD12_WCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WD11_WCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WD11_WCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WD10_WCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WD10_WCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WD9_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WD9_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WD8_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WD8_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WD7_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WD7_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WD6_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WD6_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WD5_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WD5_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WD4_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WD4_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WD3_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WD3_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WD2_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WD2_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WD1_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WD1_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WD0_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WD0_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WD17_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WD17_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WD16_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WD16_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WD15_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WD15_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WD14_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WD14_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WD13_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WD13_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WD12_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WD12_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WD11_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WD11_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WD10_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WD10_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WD9_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WD9_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WD8_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WD8_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WD7_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WD7_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WD6_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WD6_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WD5_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WD5_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WD4_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WD4_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WD3_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WD3_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WD2_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WD2_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WD1_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WD1_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WD0_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
      thold_WD0_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_WADDR8_WCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WADDR8_WCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WADDR7_WCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WADDR7_WCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WADDR6_WCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WADDR6_WCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WADDR5_WCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WADDR5_WCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WADDR4_WCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WADDR4_WCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WADDR3_WCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WADDR3_WCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WADDR2_WCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WADDR2_WCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WADDR1_WCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WADDR1_WCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WADDR0_WCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_WADDR0_WCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      thold_WADDR8_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;    
      thold_WADDR8_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WADDR7_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WADDR7_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WADDR6_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WADDR6_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WADDR5_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WADDR5_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WADDR4_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WADDR4_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WADDR3_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WADDR3_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WADDR2_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WADDR2_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WADDR1_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WADDR1_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WADDR0_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_WADDR0_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_WW1_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_WW1_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_WW0_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_WW0_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_WEN_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_WEN_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_WW1_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_WW1_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_WW0_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_WW0_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_WEN_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_WEN_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
      tsetup_RADDR8_RCLK_posedge_posedge : VitalDelayType := 0.000 ns;    
      tsetup_RADDR8_RCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_RADDR7_RCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_RADDR7_RCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_RADDR6_RCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_RADDR6_RCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_RADDR5_RCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_RADDR5_RCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_RADDR4_RCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_RADDR4_RCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_RADDR3_RCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_RADDR3_RCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_RADDR2_RCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_RADDR2_RCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_RADDR1_RCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_RADDR1_RCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_RADDR0_RCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      tsetup_RADDR0_RCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      thold_RADDR8_RCLK_posedge_posedge  : VitalDelayType := 0.000 ns;    
      thold_RADDR8_RCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_RADDR7_RCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_RADDR7_RCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_RADDR6_RCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_RADDR6_RCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_RADDR5_RCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_RADDR5_RCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_RADDR4_RCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_RADDR4_RCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_RADDR3_RCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_RADDR3_RCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_RADDR2_RCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_RADDR2_RCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_RADDR1_RCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_RADDR1_RCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      thold_RADDR0_RCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
      thold_RADDR0_RCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_RW1_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_RW1_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_RW0_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_RW0_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_REN_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
      tsetup_REN_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_RW1_RCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_RW1_RCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_RW0_RCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_RW0_RCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_REN_RCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_REN_RCLK_negedge_posedge     : VitalDelayType := 0.000 ns;      
      tsetup_PIPE_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
      tsetup_PIPE_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
      thold_PIPE_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_PIPE_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
      tpw_WCLK_posedge                   : VitalDelayType := 0.000 ns;
      tpw_WCLK_negedge                   : VitalDelayType := 0.000 ns;
      tpw_RCLK_posedge                   : VitalDelayType := 0.000 ns;
      tpw_RCLK_negedge                   : VitalDelayType := 0.000 ns;
      trecovery_RESET_RCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      trecovery_RESET_WCLK_posedge_posedge : VitalDelayType := 0.000 ns;
      thold_RESET_RCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_RESET_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
      tpw_RESET_negedge                    : VitalDelayType := 0.000 ns
     );

     port (
           RADDR8        : IN STD_ULOGIC ;
           RADDR7        : IN STD_ULOGIC ;
           RADDR6        : IN STD_ULOGIC ;
           RADDR5        : IN STD_ULOGIC ;
           RADDR4        : IN STD_ULOGIC ;
           RADDR3        : IN STD_ULOGIC ;
           RADDR2        : IN STD_ULOGIC ;
           RADDR1        : IN STD_ULOGIC ;  
           RADDR0        : IN STD_ULOGIC ;
           WADDR8        : IN STD_ULOGIC ;
           WADDR7        : IN STD_ULOGIC ;
           WADDR6        : IN STD_ULOGIC ;
           WADDR5        : IN STD_ULOGIC ;
           WADDR4        : IN STD_ULOGIC ;
           WADDR3        : IN STD_ULOGIC ;
           WADDR2        : IN STD_ULOGIC ;
           WADDR1        : IN STD_ULOGIC ;
           WADDR0        : IN STD_ULOGIC ;
           WD17          : IN STD_ULOGIC ;
           WD16          : IN STD_ULOGIC ;
           WD15          : IN STD_ULOGIC ;
           WD14          : IN STD_ULOGIC ;
           WD13          : IN STD_ULOGIC ;
           WD12          : IN STD_ULOGIC ;
           WD11          : IN STD_ULOGIC ;
           WD10          : IN STD_ULOGIC ;
           WD9           : IN STD_ULOGIC ;
           WD8           : IN STD_ULOGIC ;
           WD7           : IN STD_ULOGIC ;
           WD6           : IN STD_ULOGIC ;
           WD5           : IN STD_ULOGIC ;
           WD4           : IN STD_ULOGIC ;
           WD3           : IN STD_ULOGIC ;
           WD2           : IN STD_ULOGIC ;
           WD1           : IN STD_ULOGIC ;
           WD0           : IN STD_ULOGIC ;
           WW1           : IN STD_ULOGIC ;
           WW0           : IN STD_ULOGIC ;
           WEN           : IN STD_ULOGIC ;
           WCLK          : IN STD_ULOGIC ;
           RW1           : IN STD_ULOGIC ;
           RW0           : IN STD_ULOGIC ;
           REN           : IN STD_ULOGIC ;
           RCLK          : IN STD_ULOGIC ;
           PIPE          : IN STD_ULOGIC ;
           RESET         : IN STD_ULOGIC ;
           RD17          : OUT STD_ULOGIC ;
           RD16          : OUT STD_ULOGIC ;
           RD15          : OUT STD_ULOGIC ;
           RD14          : OUT STD_ULOGIC ;
           RD13          : OUT STD_ULOGIC ;
           RD12          : OUT STD_ULOGIC ;
           RD11          : OUT STD_ULOGIC ;
           RD10          : OUT STD_ULOGIC ;
           RD9           : OUT STD_ULOGIC ;
           RD8           : OUT STD_ULOGIC ;
           RD7           : OUT STD_ULOGIC ;
           RD6           : OUT STD_ULOGIC ;
           RD5           : OUT STD_ULOGIC ;
           RD4           : OUT STD_ULOGIC ;
           RD3           : OUT STD_ULOGIC ;
           RD2           : OUT STD_ULOGIC ;
           RD1           : OUT STD_ULOGIC ;
           RD0           : OUT STD_ULOGIC
  );

end component;

component FIFO4K18
  generic(

          TimingChecksOn : Boolean := True;
          InstancePath   : String  := "*";
          Xon            : Boolean := False;
          MsgOn          : Boolean := True;

          tipd_AEVAL11  : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AEVAL10  : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AEVAL9   : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AEVAL8   : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AEVAL7   : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AEVAL6   : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AEVAL5   : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AEVAL4   : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AEVAL3   : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AEVAL2   : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AEVAL1   : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AEVAL0   : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AFVAL11  : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AFVAL10  : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AFVAL9   : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AFVAL8   : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AFVAL7   : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AFVAL6   : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AFVAL5   : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AFVAL4   : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AFVAL3   : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AFVAL2   : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AFVAL1   : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_AFVAL0   : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_REN      : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_RCLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_RBLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WEN      : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WBLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WCLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_RESET    : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_RPIPE    : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_RW2      : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_RW1      : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_RW0      : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WW2      : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WW1      : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WW0      : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_ESTOP    : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_FSTOP    : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WD17     : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WD16     : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WD15     : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WD14     : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WD13     : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WD12     : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WD11     : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WD10     : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WD9      : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WD8      : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WD7      : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WD6      : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WD5      : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WD4      : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WD3      : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WD2      : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WD1      : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tipd_WD0      : VitalDelayType01 := (0.000 ns, 0.000 ns);
          tpd_RCLK_RD17     : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RCLK_RD16     : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RCLK_RD15     : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RCLK_RD14     : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RCLK_RD13     : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RCLK_RD12     : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RCLK_RD11     : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RCLK_RD10     : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RCLK_RD9      : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RCLK_RD8      : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RCLK_RD7      : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RCLK_RD6      : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RCLK_RD5      : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RCLK_RD4      : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RCLK_RD3      : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RCLK_RD2      : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RCLK_RD1      : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RCLK_RD0      : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RCLK_EMPTY    : VitalDelayType01 := (0.100 ns, 0.100 ns); 
          tpd_RCLK_AEMPTY   : VitalDelayType01 := (0.100 ns, 0.100 ns); 
          tpd_RCLK_AFULL    : VitalDelayType01 := (0.100 ns, 0.100 ns); 
          tpd_WCLK_FULL     : VitalDelayType01 := (0.100 ns, 0.100 ns); 
          tpd_WCLK_AFULL    : VitalDelayType01 := (0.100 ns, 0.100 ns); 
          tpd_WCLK_AEMPTY   : VitalDelayType01 := (0.100 ns, 0.100 ns); 
          tpd_RESET_RD17    : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RESET_RD16    : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RESET_RD15    : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RESET_RD14    : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RESET_RD13    : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RESET_RD12    : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RESET_RD11    : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RESET_RD10    : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RESET_RD9     : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RESET_RD8     : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RESET_RD7     : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RESET_RD6     : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RESET_RD5     : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RESET_RD4     : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RESET_RD3     : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RESET_RD2     : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RESET_RD1     : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RESET_RD0     : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RESET_EMPTY   : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RESET_AEMPTY  : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RESET_FULL    : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tpd_RESET_AFULL   : VitalDelayType01 := (0.100 ns, 0.100 ns);
          tsetup_WD17_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD17_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD16_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD16_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD15_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD15_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD14_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD14_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD13_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD13_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD12_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD12_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD11_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD11_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD10_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD10_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD9_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD9_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD8_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD8_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD7_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD7_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD6_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD6_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD5_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD5_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD4_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD4_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD3_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD3_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD2_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD2_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD1_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD1_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD0_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WD0_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD17_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD17_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD16_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD16_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD15_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD15_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD14_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD14_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD13_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD13_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD12_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD12_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD11_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD11_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD10_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD10_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD9_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD9_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD8_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD8_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD7_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD7_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD6_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD6_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD5_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD5_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD4_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD4_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD3_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD3_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD2_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD2_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD1_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD1_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD0_WCLK_posedge_posedge              : VitalDelayType := 0.000 ns;
          thold_WD0_WCLK_negedge_posedge              : VitalDelayType := 0.000 ns;
          tsetup_WEN_WCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_WEN_WCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_WBLK_WCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_WBLK_WCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          thold_WEN_WCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          thold_WEN_WCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          thold_WBLK_WCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          thold_WBLK_WCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_REN_RCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_REN_RCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_RBLK_RCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_RBLK_RCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          thold_REN_RCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          thold_REN_RCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          thold_RBLK_RCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          thold_RBLK_RCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_FSTOP_WCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_FSTOP_WCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_ESTOP_RCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_ESTOP_RCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          thold_FSTOP_WCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          thold_FSTOP_WCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          thold_ESTOP_RCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          thold_ESTOP_RCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_WW2_WCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_WW2_WCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_WW1_WCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_WW1_WCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_WW0_WCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_WW0_WCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          thold_WW2_WCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          thold_WW2_WCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          thold_WW1_WCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          thold_WW1_WCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          thold_WW0_WCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          thold_WW0_WCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_RW2_RCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_RW2_RCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_RW1_RCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_RW1_RCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_RW0_RCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          tsetup_RW0_RCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          thold_RW2_RCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          thold_RW2_RCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          thold_RW1_RCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          thold_RW1_RCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          thold_RW0_RCLK_posedge_posedge             : VitalDelayType := 0.000 ns;
          thold_RW0_RCLK_negedge_posedge             : VitalDelayType := 0.000 ns;
          tpw_WCLK_posedge                           : VitalDelayType := 0.000 ns;
          tpw_WCLK_negedge                           : VitalDelayType := 0.000 ns;
          tperiod_WCLK                               : VitalDelayType := 0.000 ns;                      
          tpw_RCLK_posedge                           : VitalDelayType := 0.000 ns;
          tpw_RCLK_negedge                           : VitalDelayType := 0.000 ns;
          tperiod_RCLK                               : VitalDelayType := 0.000 ns;                      
          trecovery_RESET_RCLK_posedge_posedge       : VitalDelayType := 0.000 ns;
          trecovery_RESET_WCLK_posedge_posedge       : VitalDelayType := 0.000 ns;
          thold_RESET_RCLK_posedge_posedge           : VitalDelayType := 0.000 ns;
          thold_RESET_WCLK_posedge_posedge           : VitalDelayType := 0.000 ns;
          tpw_RESET_negedge                          : VitalDelayType := 0.000 ns

         );

port (
          AEVAL11       : IN STD_ULOGIC ;
          AEVAL10       : IN STD_ULOGIC ;
          AEVAL9       : IN STD_ULOGIC ;
          AEVAL8       : IN STD_ULOGIC ;
          AEVAL7       : IN STD_ULOGIC ;
          AEVAL6       : IN STD_ULOGIC ;
          AEVAL5       : IN STD_ULOGIC ;
          AEVAL4       : IN STD_ULOGIC ;
          AEVAL3       : IN STD_ULOGIC ;
          AEVAL2       : IN STD_ULOGIC ;
          AEVAL1       : IN STD_ULOGIC ;
          AEVAL0       : IN STD_ULOGIC ;
          AFVAL11       : IN STD_ULOGIC ;
          AFVAL10       : IN STD_ULOGIC ;
          AFVAL9       : IN STD_ULOGIC ;
          AFVAL8       : IN STD_ULOGIC ;
          AFVAL7       : IN STD_ULOGIC ;
          AFVAL6       : IN STD_ULOGIC ;
          AFVAL5       : IN STD_ULOGIC ;
          AFVAL4       : IN STD_ULOGIC ;
          AFVAL3       : IN STD_ULOGIC ;
          AFVAL2       : IN STD_ULOGIC ;
          AFVAL1       : IN STD_ULOGIC ;
          AFVAL0       : IN STD_ULOGIC ;
          REN          : IN STD_ULOGIC ;
          RBLK          : IN STD_ULOGIC ;
          RCLK          : IN STD_ULOGIC ;
          RESET         : IN STD_ULOGIC ;
          RPIPE         : IN STD_ULOGIC ;
          WEN           : IN STD_ULOGIC ;
          WBLK          : IN STD_ULOGIC ;
          WCLK          : IN STD_ULOGIC ;
          RW2           : IN STD_ULOGIC ;
          RW1           : IN STD_ULOGIC ;
          RW0           : IN STD_ULOGIC ;
          WW2           : IN STD_ULOGIC ;
          WW1           : IN STD_ULOGIC ;
          WW0           : IN STD_ULOGIC ;
          ESTOP         : IN STD_ULOGIC ;
          FSTOP         : IN STD_ULOGIC ;
          WD17          : IN STD_ULOGIC ;
          WD16          : IN STD_ULOGIC ;
          WD15          : IN STD_ULOGIC ;
          WD14          : IN STD_ULOGIC ;
          WD13          : IN STD_ULOGIC ;
          WD12          : IN STD_ULOGIC ;
          WD11          : IN STD_ULOGIC ;
          WD10          : IN STD_ULOGIC ;
          WD9           : IN STD_ULOGIC ;
          WD8           : IN STD_ULOGIC ;
          WD7           : IN STD_ULOGIC ;
          WD6           : IN STD_ULOGIC ;
          WD5           : IN STD_ULOGIC ;
          WD4           : IN STD_ULOGIC ;
          WD3           : IN STD_ULOGIC ;
          WD2           : IN STD_ULOGIC ;
          WD1           : IN STD_ULOGIC ;
          WD0           : IN STD_ULOGIC ;
          RD17          : OUT STD_ULOGIC ;
          RD16          : OUT STD_ULOGIC ;
          RD15          : OUT STD_ULOGIC ;
          RD14          : OUT STD_ULOGIC ;
          RD13          : OUT STD_ULOGIC ;
          RD12          : OUT STD_ULOGIC ;
          RD11          : OUT STD_ULOGIC ;
          RD10          : OUT STD_ULOGIC ;
          RD9           : OUT STD_ULOGIC ;
          RD8           : OUT STD_ULOGIC ;
          RD7           : OUT STD_ULOGIC ;
          RD6           : OUT STD_ULOGIC ;
          RD5           : OUT STD_ULOGIC ;
          RD4           : OUT STD_ULOGIC ;
          RD3           : OUT STD_ULOGIC ;
          RD2           : OUT STD_ULOGIC ;
          RD1           : OUT STD_ULOGIC ;
          RD0           : OUT STD_ULOGIC ;
          FULL          : OUT STD_ULOGIC ;
          AFULL         : OUT STD_ULOGIC ;
          EMPTY         : OUT STD_ULOGIC ;
          AEMPTY        : OUT STD_ULOGIC
         );


end component;


 
component DDR_OUT 
    generic(
                TimingChecksOn: Boolean := True;
                InstancePath: STRING := "*";
                Xon: Boolean := False;
                MsgOn: Boolean := True;
                tpd_CLR_Q      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_CLK_Q     :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tsetup_DR_CLK_posedge_posedge :   VitalDelayType := 0.000 ns;
                thold_DR_CLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
                tsetup_DR_CLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                thold_DR_CLK_negedge_posedge   :   VitalDelayType := 0.000 ns;

                tsetup_DF_CLK_posedge_posedge :   VitalDelayType := 0.000 ns;
                thold_DF_CLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
                tsetup_DF_CLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                thold_DF_CLK_negedge_posedge   :   VitalDelayType := 0.000 ns;

                thold_CLR_CLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                trecovery_CLR_CLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                tperiod_CLK_posedge    :  VitalDelayType := 0.000 ns;
                tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
                tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
                tpw_CLR_posedge :  VitalDelayType := 0.000 ns;
                tipd_DR        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_DF        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_CLR        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_CLK            :    VitalDelayType01 := (0.000 ns, 0.000 ns));


  port(
                CLR             :   in    STD_ULOGIC;
                CLK            :   in    STD_ULOGIC;
                DR             :  in    STD_ULOGIC;
                DF             :  in    STD_ULOGIC;
                Q               :  out    STD_ULOGIC);
 end component;

  component DDR_REG 
    generic(
                TimingChecksOn: Boolean := True;
                InstancePath: STRING := "*";
                Xon: Boolean := False;
                MsgOn: Boolean := True;
                tpd_CLR_QR      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_CLR_QF      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_CLK_QR     :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_CLK_QF     :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tsetup_D_CLK_posedge_posedge :   VitalDelayType := 0.000 ns;
                thold_D_CLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
                tsetup_D_CLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                thold_D_CLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                thold_CLR_CLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                trecovery_CLR_CLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                tperiod_CLK_posedge    :  VitalDelayType := 0.000 ns;
                tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
                tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
                tpw_CLR_posedge :  VitalDelayType := 0.000 ns;
                tipd_D        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_CLR        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_CLK            :    VitalDelayType01 := (0.000 ns, 0.000 ns));


  port(
                CLR             :   in    STD_ULOGIC;
                CLK            :   in    STD_ULOGIC;
                D             :  in    STD_ULOGIC;
                QF               :  out    STD_ULOGIC;
                QR               :  out    STD_ULOGIC);

 end component;

------ Component IOBI_ID_OB_EB ------
 component IOBI_ID_OB_EB
   generic (
      TimingChecksOn   : Boolean := True;
      InstancePath     : String  := "*";
      Xon              : Boolean := False;
      MsgOn            : Boolean := True;

      tipd_D           : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR         : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E           : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ICLK        : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_YIN         : VitalDelayType01 := (0.000 ns, 0.000 ns);

      tpd_D_DOUT       : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_E_EOUT       : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_CLR_YR       : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_CLR_YF       : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_ICLK_YR      : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_ICLK_YF      : VitalDelayType01 := (0.100 ns, 0.100 ns);

      tsetup_YIN_ICLK_posedge_posedge    : VitalDelayType := 0.000 ns;
      thold_YIN_ICLK_posedge_posedge     : VitalDelayType := 0.000 ns;
      tsetup_YIN_ICLK_negedge_posedge    : VitalDelayType := 0.000 ns;
      thold_YIN_ICLK_negedge_posedge     : VitalDelayType := 0.000 ns;

      tsetup_YIN_ICLK_posedge_negedge    : VitalDelayType := 0.000 ns;
      thold_YIN_ICLK_posedge_negedge     : VitalDelayType := 0.000 ns;
      tsetup_YIN_ICLK_negedge_negedge    : VitalDelayType := 0.000 ns;
      thold_YIN_ICLK_negedge_negedge     : VitalDelayType := 0.000 ns;

      trecovery_CLR_ICLK_negedge_posedge : VitalDelayType := 0.000 ns;
      thold_CLR_ICLK_negedge_posedge     : VitalDelayType := 0.000 ns;

      tpw_ICLK_posedge                   :  VitalDelayType := 0.000 ns;
      tpw_ICLK_negedge                   :  VitalDelayType := 0.000 ns;
      tperiod_ICLK_posedge               :  VitalDelayType := 0.000 ns;
      tpw_CLR_posedge                    :  VitalDelayType := 0.000 ns
     );


   port (
      D             :  in    std_ulogic;
      CLR           :  in    std_ulogic;
      E             :  in    std_ulogic;
      ICLK          :  in    std_ulogic;
      YIN           :  in    std_ulogic;
      DOUT          :  out   std_ulogic;
      EOUT          :  out   std_ulogic;
      YR            :  out   std_ulogic;
      YF            :  out   std_ulogic
     );
 end component;

 component IOBI_ID_OD_EB 
    generic(
                TimingChecksOn: Boolean := True;
                InstancePath: STRING := "*";
                Xon: Boolean := False;
                MsgOn: Boolean := True;
                tpd_CLR_DOUT      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_OCLK_DOUT     :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_CLR_YR      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_ICLK_YR     :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_CLR_YF      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_ICLK_YF     :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_EOUT      :  VitalDelayType01 := (0.100 ns, 0.100 ns);

                tsetup_YIN_ICLK_posedge_posedge :   VitalDelayType := 0.000 ns;
                thold_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
                tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                thold_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;

                tsetup_YIN_ICLK_posedge_negedge :   VitalDelayType := 0.000 ns;
                thold_YIN_ICLK_posedge_negedge   :   VitalDelayType := 0.000 ns;
                tsetup_YIN_ICLK_negedge_negedge   :   VitalDelayType := 0.000 ns;
                thold_YIN_ICLK_negedge_negedge   :   VitalDelayType := 0.000 ns;

                tsetup_DF_OCLK_posedge_posedge :   VitalDelayType := 0.000 ns;
                thold_DF_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
                tsetup_DF_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                thold_DF_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;

                tsetup_DR_OCLK_posedge_posedge :   VitalDelayType := 0.000 ns;
                thold_DR_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
                tsetup_DR_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                thold_DR_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;



                thold_CLR_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                trecovery_CLR_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                tperiod_OCLK_posedge    :  VitalDelayType := 0.000 ns;
                thold_CLR_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                trecovery_CLR_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                tperiod_ICLK_posedge    :  VitalDelayType := 0.000 ns;

                tpw_OCLK_posedge :  VitalDelayType := 0.000 ns;
                tpw_OCLK_negedge  :  VitalDelayType := 0.000 ns;
                tpw_ICLK_posedge :  VitalDelayType := 0.000 ns;
                tpw_ICLK_negedge  :  VitalDelayType := 0.000 ns;

                tpw_CLR_posedge :  VitalDelayType := 0.000 ns;
                tipd_DR        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_DF        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_E        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_YIN        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_ICLK            :    VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_CLR        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_OCLK            :    VitalDelayType01 := (0.000 ns, 0.000 ns));


  port(
                CLR             :   in    STD_ULOGIC;
                OCLK            :   in    STD_ULOGIC;
                ICLK            :   in    STD_ULOGIC;
                YIN             :   in    STD_ULOGIC;
                E               :   in    STD_ULOGIC;
                DR             :  in    STD_ULOGIC;
                DF             :  in    STD_ULOGIC;
                YR               :  out    STD_ULOGIC;
                YF               :  out    STD_ULOGIC;
                DOUT               :  out    STD_ULOGIC;
                EOUT               :  out    STD_ULOGIC);

 end component;

 component IOBI_ID_OD_ERC 
    generic(
                TimingChecksOn: Boolean := True;
                InstancePath: STRING := "*";
                Xon: Boolean := False;
                MsgOn: Boolean := True;
                tpd_CLR_DOUT      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_OCLK_DOUT     :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_CLR_EOUT      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_OCLK_EOUT     :  VitalDelayType01 := (0.100 ns, 0.100 ns);

                tpd_CLR_YR      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_ICLK_YR     :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_CLR_YF      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_ICLK_YF     :  VitalDelayType01 := (0.100 ns, 0.100 ns);

                tsetup_YIN_ICLK_posedge_posedge :   VitalDelayType := 0.000 ns;
                thold_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
                tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                thold_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;

                tsetup_YIN_ICLK_posedge_negedge :   VitalDelayType := 0.000 ns;
                thold_YIN_ICLK_posedge_negedge   :   VitalDelayType := 0.000 ns;
                tsetup_YIN_ICLK_negedge_negedge   :   VitalDelayType := 0.000 ns;
                thold_YIN_ICLK_negedge_negedge   :   VitalDelayType := 0.000 ns;

                tsetup_DF_OCLK_posedge_posedge :   VitalDelayType := 0.000 ns;
                thold_DF_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
                tsetup_DF_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                thold_DF_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;

                tsetup_DR_OCLK_posedge_posedge :   VitalDelayType := 0.000 ns;
                thold_DR_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
                tsetup_DR_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                thold_DR_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;

                tsetup_E_OCLK_posedge_posedge :   VitalDelayType := 0.000 ns;
                thold_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
                tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                thold_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
    
                
                thold_CLR_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                trecovery_CLR_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                tperiod_OCLK_posedge    :  VitalDelayType := 0.000 ns;
                thold_CLR_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                trecovery_CLR_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                tperiod_ICLK_posedge    :  VitalDelayType := 0.000 ns;

                tpw_OCLK_posedge :  VitalDelayType := 0.000 ns;
                tpw_OCLK_negedge  :  VitalDelayType := 0.000 ns;
                tpw_ICLK_posedge :  VitalDelayType := 0.000 ns;
                tpw_ICLK_negedge  :  VitalDelayType := 0.000 ns;
                tpw_CLR_posedge    :  VitalDelayType := 0.000 ns;
                tipd_DR        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_DF        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_E        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_YIN        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_ICLK            :    VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_CLR        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_OCLK            :    VitalDelayType01 := (0.000 ns, 0.000 ns));


  port(
                CLR             :   in    STD_ULOGIC;
                OCLK            :   in    STD_ULOGIC;
                ICLK            :   in    STD_ULOGIC;
                YIN             :   in    STD_ULOGIC;
                E               :   in    STD_ULOGIC;
                DR             :  in    STD_ULOGIC;
                DF             :  in    STD_ULOGIC;
                YR               :  out    STD_ULOGIC;
                YF               :  out    STD_ULOGIC;
                DOUT               :  out    STD_ULOGIC;
                EOUT               :  out    STD_ULOGIC);

 end component;


 component IOIN_ID 
    generic(
                TimingChecksOn: Boolean := True;
                InstancePath: STRING := "*";
                Xon: Boolean := False;
                MsgOn: Boolean := True;
                tpd_CLR_YR      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_CLR_YF      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_ICLK_YR     :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_ICLK_YF     :  VitalDelayType01 := (0.100 ns, 0.100 ns);

                tsetup_YIN_ICLK_posedge_posedge :   VitalDelayType := 0.000 ns;
                thold_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
                tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                thold_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                tsetup_YIN_ICLK_posedge_negedge   :   VitalDelayType := 0.000 ns;
                thold_YIN_ICLK_posedge_negedge    :   VitalDelayType := 0.000 ns;
                tsetup_YIN_ICLK_negedge_negedge   :   VitalDelayType := 0.000 ns;
                thold_YIN_ICLK_negedge_negedge    :   VitalDelayType := 0.000 ns;

                thold_CLR_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                trecovery_CLR_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                tperiod_ICLK_posedge    :  VitalDelayType := 0.000 ns;
                tpw_ICLK_posedge :  VitalDelayType := 0.000 ns;
                tpw_ICLK_negedge  :  VitalDelayType := 0.000 ns;
                tpw_CLR_posedge :  VitalDelayType := 0.000 ns;
                tipd_YIN        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_CLR        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_ICLK            :    VitalDelayType01 := (0.000 ns, 0.000 ns));

 
  port(
                CLR             :   in    STD_ULOGIC;
                ICLK            :   in    STD_ULOGIC;
                YIN             :  in    STD_ULOGIC;
                YF               :  out    STD_ULOGIC;
                YR               :  out    STD_ULOGIC);

 end component;


 component IOTRI_OD_EB 
    generic(
                TimingChecksOn: Boolean := True;
                InstancePath: STRING := "*";
                Xon: Boolean := False;
                MsgOn: Boolean := True;
                tpd_CLR_DOUT      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_OCLK_DOUT     :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_EOUT     :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tsetup_DR_OCLK_posedge_posedge :   VitalDelayType := 0.000 ns;
                thold_DR_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
                tsetup_DR_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                thold_DR_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;

                tsetup_DF_OCLK_posedge_posedge :   VitalDelayType := 0.000 ns;
                thold_DF_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
                tsetup_DF_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                thold_DF_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;

                thold_CLR_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                trecovery_CLR_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                tperiod_OCLK_posedge    :  VitalDelayType := 0.000 ns;
                tpw_OCLK_posedge :  VitalDelayType := 0.000 ns;
                tpw_OCLK_negedge  :  VitalDelayType := 0.000 ns;
                tpw_CLR_posedge :  VitalDelayType := 0.000 ns;
                tipd_DR        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_DF        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_E        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_CLR        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_OCLK            :    VitalDelayType01 := (0.000 ns, 0.000 ns));




  port(
                CLR             :   in    STD_ULOGIC;
                OCLK            :   in    STD_ULOGIC;
                DR             :  in    STD_ULOGIC;
                DF             :  in    STD_ULOGIC;
                E              :  in    STD_ULOGIC;
                DOUT               :  out    STD_ULOGIC;
                EOUT               :  out    STD_ULOGIC);

 end component;

 component IOTRI_OD_ERC 
    generic(
                TimingChecksOn: Boolean := True;
                InstancePath: STRING := "*";
                Xon: Boolean := False;
                MsgOn: Boolean := True;
                tpd_CLR_DOUT      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_OCLK_DOUT     :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_CLR_EOUT      :  VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_OCLK_EOUT     :  VitalDelayType01 := (0.100 ns, 0.100 ns);

                tsetup_E_OCLK_posedge_posedge :   VitalDelayType := 0.000 ns;
                thold_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
                tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                thold_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;

                tsetup_DR_OCLK_posedge_posedge :   VitalDelayType := 0.000 ns;
                thold_DR_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
                tsetup_DR_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                thold_DR_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;

                tsetup_DF_OCLK_posedge_posedge :   VitalDelayType := 0.000 ns;
                thold_DF_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
                tsetup_DF_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                thold_DF_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;


                thold_CLR_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                trecovery_CLR_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
                tperiod_OCLK_posedge    :  VitalDelayType := 0.000 ns;
                tpw_OCLK_posedge :  VitalDelayType := 0.000 ns;
                tpw_OCLK_negedge  :  VitalDelayType := 0.000 ns;
                tpw_CLR_posedge :  VitalDelayType := 0.000 ns;
                tipd_DR        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_DF        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_E        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_CLR        :   VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_OCLK            :    VitalDelayType01 := (0.000 ns, 0.000 ns));


  port(
                CLR             :   in    STD_ULOGIC;
                OCLK            :   in    STD_ULOGIC;
                DR             :  in    STD_ULOGIC;
                DF             :  in    STD_ULOGIC;
                E             :  in    STD_ULOGIC;
                DOUT               :  out    STD_ULOGIC;
                EOUT               :  out    STD_ULOGIC);

 end component;

------ Component AND2 ------
 component AND2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND2A ------
 component AND2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND2B ------
 component AND2B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND2FT ------
 component AND2FT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND3 ------
 component AND3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND3A ------
 component AND3A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND3B ------
 component AND3B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND3C ------
 component AND3C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO12 ------
 component AO12
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO13 ------
 component AO13
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO14 ------
 component AO14
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO15 ------
 component AO15
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO16 ------
 component AO16
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO17 ------
 component AO17
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO18 ------
 component AO18
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO1 ------
 component AO1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO1A ------
 component AO1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO1B ------
 component AO1B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO1C ------
 component AO1C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO1D ------
 component AO1D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO1E ------
 component AO1E
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI1 ------
 component AOI1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI1A ------
 component AOI1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI1B ------
 component AOI1B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI1C ------
 component AOI1C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI1D ------
 component AOI1D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI5 ------
 component AOI5
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AX1 ------
 component AX1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AX1A ------
 component AX1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AX1B ------
 component AX1B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AX1C ------
 component AX1C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AX1D ------
 component AX1D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AX1E ------
 component AX1E
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXO1 ------
 component AXO1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXO2 ------
 component AXO2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXO3 ------
 component AXO3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXO5 ------
 component AXO5
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXO6 ------
 component AXO6
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXO7 ------
 component AXO7
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXOI1 ------
 component AXOI1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXOI2 ------
 component AXOI2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXOI3 ------
 component AXOI3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXOI4 ------
 component AXOI4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXOI5 ------
 component AXOI5
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXOI7 ------
 component AXOI7
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF ------
 component BIBUF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_12 ------
 component BIBUF_F_12
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_12D ------
 component BIBUF_F_12D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_12U ------
 component BIBUF_F_12U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_16 ------
 component BIBUF_F_16
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_16D ------
 component BIBUF_F_16D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_16U ------
 component BIBUF_F_16U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_24 ------
 component BIBUF_F_24
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_24D ------
 component BIBUF_F_24D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_24U ------
 component BIBUF_F_24U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_8 ------
 component BIBUF_F_8
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_8D ------
 component BIBUF_F_8D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_8U ------
 component BIBUF_F_8U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_GTLP25 ------
 component BIBUF_GTLP25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_GTLP33 ------
 component BIBUF_GTLP33
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_HSTL_I ------
 component BIBUF_HSTL_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS15 ------
 component BIBUF_LVCMOS15
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS15D ------
 component BIBUF_LVCMOS15D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS15U ------
 component BIBUF_LVCMOS15U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;

------ Component BIBUF_LVCMOS12 ------
 component BIBUF_LVCMOS12
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS12D ------
 component BIBUF_LVCMOS12D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS12U ------
 component BIBUF_LVCMOS12U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS18 ------
 component BIBUF_LVCMOS18
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS18D ------
 component BIBUF_LVCMOS18D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS18U ------
 component BIBUF_LVCMOS18U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS25 ------
 component BIBUF_LVCMOS25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS25D ------
 component BIBUF_LVCMOS25D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS25U ------
 component BIBUF_LVCMOS25U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS33 ------
 component BIBUF_LVCMOS33
    generic(
                TimingChecksOn:Boolean := True;
                Xon: Boolean := False;
                InstancePath: STRING :="*";
                MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

                tpd_D_PAD               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
                tpd_PAD_Y               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                        tpd_D_Y                 : VitalDelayType01 := (0.100 ns, 0.100 ns);
                        tpd_E_Y                 : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tipd_D          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_E          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_PAD                : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                D               : in    STD_ULOGIC;
                E               : in    STD_ULOGIC;
                PAD             : inout STD_ULOGIC;
                Y               : out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS33D ------
 component BIBUF_LVCMOS33D
    generic(
                TimingChecksOn:Boolean := True;
                Xon: Boolean := False;
                InstancePath: STRING :="*";
                MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

                tpd_D_PAD               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
                tpd_PAD_Y               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                        tpd_D_Y                 : VitalDelayType01 := (0.100 ns, 0.100 ns);
                        tpd_E_Y                 : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tipd_D          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_E          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_PAD                : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                D               : in    STD_ULOGIC;
                E               : in    STD_ULOGIC;
                PAD             : inout STD_ULOGIC;
                Y               : out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS33U ------
 component BIBUF_LVCMOS33U
    generic(
                TimingChecksOn:Boolean := True;
                Xon: Boolean := False;
                InstancePath: STRING :="*";
                MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

                tpd_D_PAD               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
                tpd_PAD_Y               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                        tpd_D_Y                 : VitalDelayType01 := (0.100 ns, 0.100 ns);
                        tpd_E_Y                 : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tipd_D          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_E          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_PAD                : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                D               : in    STD_ULOGIC;
                E               : in    STD_ULOGIC;
                PAD             : inout STD_ULOGIC;
                Y               : out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS5 ------
 component BIBUF_LVCMOS5
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS5D ------
 component BIBUF_LVCMOS5D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS5U ------
 component BIBUF_LVCMOS5U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


component BIBUF_LVDS
    generic(
       TimingChecksOn : Boolean  := True;
       Xon            : Boolean  := False;
       InstancePath   : STRING   := "*";
       MsgOn          : Boolean  := True;

                tpw_D_posedge    : VitalDelayType    := 0.000 ns;
                tpw_D_negedge    : VitalDelayType    := 0.000 ns;
                tpw_E_posedge    : VitalDelayType    := 0.000 ns;
                tpw_E_negedge    : VitalDelayType    := 0.000 ns;
                tpw_PADP_negedge : VitalDelayType    := 0.000 ns;
                tpw_PADP_posedge : VitalDelayType    := 0.000 ns;
                tpw_PADN_negedge : VitalDelayType    := 0.000 ns;
                tpw_PADN_posedge : VitalDelayType    := 0.000 ns;

                tpd_D_PADP       : VitalDelayType01  := (0.100 ns, 0.100 ns);
                tpd_E_PADP       : VitalDelayType01Z := (0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns);
                tpd_D_PADN       : VitalDelayType01  := (0.100 ns, 0.100 ns);
                tpd_E_PADN       : VitalDelayType01Z := (0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns);
                tpd_PADP_Y       : VitalDelayType01  := (0.100 ns, 0.100 ns);
                tpd_PADN_Y       : VitalDelayType01  := (0.100 ns, 0.100 ns);
                tpd_D_Y          : VitalDelayType01  := (0.100 ns, 0.100 ns);
                tpd_E_Y          : VitalDelayType01  := (0.100 ns, 0.100 ns);

                tipd_D           : VitalDelayType01  := (0.000 ns, 0.000 ns);
                tipd_E           : VitalDelayType01  := (0.000 ns, 0.000 ns);
                tipd_PADP        : VitalDelayType01  := (0.000 ns, 0.000 ns);
                tipd_PADN        : VitalDelayType01  := (0.000 ns, 0.000 ns));


    port(
                D               : in    STD_ULOGIC;
                E               : in    STD_ULOGIC;
                PADP            : inout STD_ULOGIC;
                PADN            : inout STD_ULOGIC;
                Y               : out   STD_ULOGIC);
end component;


------ Component BIBUF_PCI ------
 component BIBUF_PCI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_PCIX ------
 component BIBUF_PCIX
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_SSTL2_I ------
 component BIBUF_SSTL2_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_SSTL2_II ------
 component BIBUF_SSTL2_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_SSTL3_I ------
 component BIBUF_SSTL3_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_SSTL3_II ------
 component BIBUF_SSTL3_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_12 ------
 component BIBUF_S_12
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_12D ------
 component BIBUF_S_12D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_12U ------
 component BIBUF_S_12U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_16 ------
 component BIBUF_S_16
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_16D ------
 component BIBUF_S_16D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_16U ------
 component BIBUF_S_16U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_24 ------
 component BIBUF_S_24
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_24D ------
 component BIBUF_S_24D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_24U ------
 component BIBUF_S_24U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_8 ------
 component BIBUF_S_8
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_8D ------
 component BIBUF_S_8D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_8U ------
 component BIBUF_S_8U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF ------
 component CLKBUF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_GTLP25 ------
 component CLKBUF_GTLP25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_GTLP33 ------
 component CLKBUF_GTLP33
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_HSTL_I ------
 component CLKBUF_HSTL_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_LVCMOS15 ------
 component CLKBUF_LVCMOS15
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;

------ Component CLKBUF_LVCMOS12 ------
 component CLKBUF_LVCMOS12
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;

------ Component CLKBUF_LVCMOS18 ------
 component CLKBUF_LVCMOS18
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_LVCMOS25 ------
 component CLKBUF_LVCMOS25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_LVCMOS33 ------
 component CLKBUF_LVCMOS33
    generic(
                TimingChecksOn:Boolean := True;
                Xon: Boolean := False;
                InstancePath: STRING :="*";
                MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

                tpd_PAD_Y               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tipd_PAD                : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                PAD             : in    STD_ULOGIC;
                Y               : out    STD_ULOGIC);
 end component;


------ Component CLKBUF_LVCMOS5 ------
 component CLKBUF_LVCMOS5
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_LVDS ------
  


component CLKBUF_LVDS
     generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;

                tpw_PADP_posedge        : VitalDelayType := 0.000 ns;
                tpw_PADP_negedge        : VitalDelayType := 0.000 ns;
                tpw_PADN_posedge        : VitalDelayType := 0.000 ns;
                tpw_PADN_negedge        : VitalDelayType := 0.000 ns;

      tpd_PADP_Y                    :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_PADN_Y                    :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_PADP                             :  VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PADN                             :  VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PADP                           :  in    STD_ULOGIC;
      PADN                           :  in    STD_ULOGIC;
      Y                              :  out   STD_ULOGIC);
 end component;

------ Component CLKBUF_LVPECL ------
 component CLKBUF_LVPECL
     generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;

                tpw_PADP_posedge        : VitalDelayType := 0.000 ns;
                tpw_PADP_negedge        : VitalDelayType := 0.000 ns;
                tpw_PADN_posedge        : VitalDelayType := 0.000 ns;
                tpw_PADN_negedge        : VitalDelayType := 0.000 ns;

      tpd_PADP_Y                    :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_PADN_Y                    :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_PADP                             :  VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PADN                             :  VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PADP                           :  in    STD_ULOGIC;
      PADN                           :  in    STD_ULOGIC;
      Y                              :  out   STD_ULOGIC);

 end component;



------ Component CLKBUF_PCI ------
 component CLKBUF_PCI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_PCIX ------
 component CLKBUF_PCIX
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_SSTL2_I ------
 component CLKBUF_SSTL2_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_SSTL2_II ------
 component CLKBUF_SSTL2_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_SSTL3_I ------
 component CLKBUF_SSTL3_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_SSTL3_II ------
 component CLKBUF_SSTL3_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component DFI0 ------
 component DFI0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI0C0 ------
 component DFI0C0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI0C1 ------
 component DFI0C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI0E0 ------
 component DFI0E0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI0E0C0 ------
 component DFI0E0C0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI0E0C1 ------
 component DFI0E0C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI0E0P0 ------
 component DFI0E0P0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI0E0P1 ------
 component DFI0E0P1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI0E1 ------
 component DFI0E1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI0E1C0 ------
 component DFI0E1C0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI0E1C1 ------
 component DFI0E1C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI0E1P0 ------
 component DFI0E1P0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI0E1P1 ------
 component DFI0E1P1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI0P0 ------
 component DFI0P0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI0P1 ------
 component DFI0P1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI0P1C1 ------
 component DFI0P1C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI1 ------
 component DFI1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI1C0 ------
 component DFI1C0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI1C1 ------
 component DFI1C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI1E0 ------
 component DFI1E0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI1E0C0 ------
 component DFI1E0C0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI1E0C1 ------
 component DFI1E0C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI1E0P0 ------
 component DFI1E0P0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI1E0P1 ------
 component DFI1E0P1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI1E1 ------
 component DFI1E1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI1E1C0 ------
 component DFI1E1C0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI1E1C1 ------
 component DFI1E1C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI1E1P0 ------
 component DFI1E1P0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI1E1P1 ------
 component DFI1E1P1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI1P0 ------
 component DFI1P0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI1P1 ------
 component DFI1P1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFI1P1C1 ------
 component DFI1P1C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DFN0 ------
 component DFN0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN0C0 ------
 component DFN0C0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN0C1 ------
 component DFN0C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN0E0 ------
 component DFN0E0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN0E0C0 ------
 component DFN0E0C0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN0E0C1 ------
 component DFN0E0C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN0E0P0 ------
 component DFN0E0P0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN0E0P1 ------
 component DFN0E0P1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN0E1 ------
 component DFN0E1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN0E1C0 ------
 component DFN0E1C0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN0E1C1 ------
 component DFN0E1C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN0E1P0 ------
 component DFN0E1P0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN0E1P1 ------
 component DFN0E1P1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN0P0 ------
 component DFN0P0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN0P1 ------
 component DFN0P1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN0P1C1 ------
 component DFN0P1C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN1 ------
 component DFN1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN1C0 ------
 component DFN1C0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN1C1 ------
 component DFN1C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN1E0 ------
 component DFN1E0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN1E0C0 ------
 component DFN1E0C0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN1E0C1 ------
 component DFN1E0C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN1E0P0 ------
 component DFN1E0P0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN1E0P1 ------
 component DFN1E0P1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN1E1 ------
 component DFN1E1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN1E1C0 ------
 component DFN1E1C0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN1E1C1 ------
 component DFN1E1C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN1E1P0 ------
 component DFN1E1P0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN1E1P1 ------
 component DFN1E1P1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN1P0 ------
 component DFN1P0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN1P1 ------
 component DFN1P1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFN1P1C1 ------
 component DFN1P1C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLI0 ------
 component DLI0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DLI0C0 ------
 component DLI0C0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DLI0C1 ------
 component DLI0C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DLI0P0 ------
 component DLI0P0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DLI0P1 ------
 component DLI0P1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DLI0P1C1 ------
 component DLI0P1C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DLI1 ------
 component DLI1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DLI1C0 ------
 component DLI1C0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DLI1C1 ------
 component DLI1C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DLI1P0 ------
 component DLI1P0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DLI1P1 ------
 component DLI1P1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DLI1P1C1 ------
 component DLI1P1C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DLN0 ------
 component DLN0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLN0C0 ------
 component DLN0C0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLN0C1 ------
 component DLN0C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLN0P0 ------
 component DLN0P0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLN0P1 ------
 component DLN0P1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLN0P1C1 ------
 component DLN0P1C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLN1 ------
 component DLN1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLN1C0 ------
 component DLN1C0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLN1C1 ------
 component DLN1C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLN1P0 ------
 component DLN1P0
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLN1P1 ------
 component DLN1P1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLN1P1C1 ------
 component DLN1P1C1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component GND ------
 component GND
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True		);
    port(
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF ------
 component INBUF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;

------ Component INBUF_FF------
 component INBUF_FF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;

------ Component INBUF_GTLP25 ------
 component INBUF_GTLP25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_GTLP33 ------
 component INBUF_GTLP33
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_HSTL_I ------
 component INBUF_HSTL_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS15 ------
 component INBUF_LVCMOS15
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS15D ------
 component INBUF_LVCMOS15D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS15U ------
 component INBUF_LVCMOS15U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;

------ Component INBUF_LVCMOS12 ------
 component INBUF_LVCMOS12
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS12D ------
 component INBUF_LVCMOS12D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS12U ------
 component INBUF_LVCMOS12U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS18 ------
 component INBUF_LVCMOS18
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS18D ------
 component INBUF_LVCMOS18D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS18U ------
 component INBUF_LVCMOS18U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS25 ------
 component INBUF_LVCMOS25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS25D ------
 component INBUF_LVCMOS25D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS25U ------
 component INBUF_LVCMOS25U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS33 ------
 component INBUF_LVCMOS33
    generic(
                TimingChecksOn:Boolean := True;
                Xon: Boolean := False;
                InstancePath: STRING :="*";
                MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

                tpd_PAD_Y               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tipd_PAD                : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                PAD             : in    STD_ULOGIC;
                Y               : out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS33D ------
 component INBUF_LVCMOS33D
    generic(
                TimingChecksOn:Boolean := True;
                Xon: Boolean := False;
                InstancePath: STRING :="*";
                MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

                tpd_PAD_Y               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tipd_PAD                : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                PAD             : in    STD_ULOGIC;
                Y               : out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS33U ------
 component INBUF_LVCMOS33U
    generic(
                TimingChecksOn:Boolean := True;
                Xon: Boolean := False;
                InstancePath: STRING :="*";
                MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

                tpd_PAD_Y               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tipd_PAD                : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                PAD             : in    STD_ULOGIC;
                Y               : out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS5 ------
 component INBUF_LVCMOS5
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS5D ------
 component INBUF_LVCMOS5D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS5U ------
 component INBUF_LVCMOS5U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


 ------ Component INBUF_LVDS ------
 component INBUF_LVDS
    generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;

                tpw_PADP_posedge        : VitalDelayType := 0.000 ns;
                tpw_PADP_negedge        : VitalDelayType := 0.000 ns;
                tpw_PADN_posedge        : VitalDelayType := 0.000 ns;
                tpw_PADN_negedge        : VitalDelayType := 0.000 ns;

      tpd_PADP_Y                    :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_PADN_Y                    :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_PADP                             :  VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PADN                             :  VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PADP                           :  in    STD_ULOGIC;
      PADN                           :  in    STD_ULOGIC;
      Y                              :  out   STD_ULOGIC);

 end component;


------ Component INBUF_LVPECL ------
 component INBUF_LVPECL
     generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;

                tpw_PADP_posedge        : VitalDelayType := 0.000 ns;
                tpw_PADP_negedge        : VitalDelayType := 0.000 ns;
                tpw_PADN_posedge        : VitalDelayType := 0.000 ns;
                tpw_PADN_negedge        : VitalDelayType := 0.000 ns;

      tpd_PADP_Y                    :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_PADN_Y                    :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_PADP                             :  VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PADN                             :  VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PADP                           :  in    STD_ULOGIC;
      PADN                           :  in    STD_ULOGIC;
      Y                              :  out   STD_ULOGIC);

 end component;


------ Component INBUF_PCI ------
 component INBUF_PCI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_PCIX ------
 component INBUF_PCIX
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_SSTL2_I ------
 component INBUF_SSTL2_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_SSTL2_II ------
 component INBUF_SSTL2_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_SSTL3_I ------
 component INBUF_SSTL3_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_SSTL3_II ------
 component INBUF_SSTL3_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INV ------
 component INV
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MAJ3 ------
 component MAJ3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MAJ3X ------
 component MAJ3X
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MAJ3XI ------
 component MAJ3XI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MIN3 ------
 component MIN3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MIN3X ------
 component MIN3X
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MIN3XI ------
 component MIN3XI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MX2 ------
 component MX2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MX2A ------
 component MX2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MX2B ------
 component MX2B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MX2C ------
 component MX2C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND2 ------
 component NAND2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND2A ------
 component NAND2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND2B ------
 component NAND2B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND3 ------
 component NAND3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND3A ------
 component NAND3A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND3B ------
 component NAND3B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND3C ------
 component NAND3C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR2 ------
 component NOR2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR2A ------
 component NOR2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR2B ------
 component NOR2B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR3 ------
 component NOR3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR3A ------
 component NOR3A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR3B ------
 component NOR3B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR3C ------
 component NOR3C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA1 ------
 component OA1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA1A ------
 component OA1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA1B ------
 component OA1B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		C		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA1C ------
 component OA1C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OAI1 ------
 component OAI1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR2 ------
 component OR2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR2A ------
 component OR2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR2B ------
 component OR2B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR3 ------
 component OR3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR3A ------
 component OR3A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR3B ------
 component OR3B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR3C ------
 component OR3C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF ------
 component OUTBUF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_F_12 ------
 component OUTBUF_F_12
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_F_16 ------
 component OUTBUF_F_16
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_F_24 ------
 component OUTBUF_F_24
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_F_8 ------
 component OUTBUF_F_8
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_GTLP25 ------
 component OUTBUF_GTLP25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_GTLP33 ------
 component OUTBUF_GTLP33
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_HSTL_I ------
 component OUTBUF_HSTL_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_LVCMOS15 ------
 component OUTBUF_LVCMOS15
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;

------ Component OUTBUF_LVCMOS12 ------
 component OUTBUF_LVCMOS12
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_LVCMOS18 ------
 component OUTBUF_LVCMOS18
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_LVCMOS25 ------
 component OUTBUF_LVCMOS25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_LVCMOS33 ------
 component OUTBUF_LVCMOS33
    generic(
                TimingChecksOn:Boolean := True;
                Xon: Boolean := False;
                InstancePath: STRING :="*";
                MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

                tpd_D_PAD               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tipd_D          : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                D               : in    STD_ULOGIC;
                PAD             : out    STD_ULOGIC);
 end component;


------ Component OUTBUF_LVCMOS5 ------
 component OUTBUF_LVCMOS5
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


 
 ------ Component OUTBUF_LVDS ------
 component OUTBUF_LVDS
     generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

      tpd_D_PADP                     :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_D_PADN                     :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_D                                 :  VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :  in    STD_ULOGIC;
      PADP                           :  out   STD_ULOGIC;
      PADN                           :  out   STD_ULOGIC);
 end component;


------ Component OUTBUF_LVPECL ------
 component OUTBUF_LVPECL
     generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

      tpd_D_PADP                     :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_D_PADN                     :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_D                         :  VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :  in    STD_ULOGIC;
      PADP                           :  out   STD_ULOGIC;
      PADN                           :  out   STD_ULOGIC);

end component;



------ Component OUTBUF_PCI ------
 component OUTBUF_PCI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_PCIX ------
 component OUTBUF_PCIX
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_SSTL2_I ------
 component OUTBUF_SSTL2_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_SSTL2_II ------
 component OUTBUF_SSTL2_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_SSTL3_I ------
 component OUTBUF_SSTL3_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_SSTL3_II ------
 component OUTBUF_SSTL3_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_S_12 ------
 component OUTBUF_S_12
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_S_16 ------
 component OUTBUF_S_16
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_S_24 ------
 component OUTBUF_S_24
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_S_8 ------
 component OUTBUF_S_8
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF ------
 component TRIBUFF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_12 ------
 component TRIBUFF_F_12
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_12D ------
 component TRIBUFF_F_12D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_12U ------
 component TRIBUFF_F_12U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_16 ------
 component TRIBUFF_F_16
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_16D ------
 component TRIBUFF_F_16D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_16U ------
 component TRIBUFF_F_16U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_24 ------
 component TRIBUFF_F_24
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_24D ------
 component TRIBUFF_F_24D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_24U ------
 component TRIBUFF_F_24U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_8 ------
 component TRIBUFF_F_8
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_8D ------
 component TRIBUFF_F_8D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_8U ------
 component TRIBUFF_F_8U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_GTLP25 ------
 component TRIBUFF_GTLP25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_GTLP33 ------
 component TRIBUFF_GTLP33
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_HSTL_I ------
 component TRIBUFF_HSTL_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS15 ------
 component TRIBUFF_LVCMOS15
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS15D ------
 component TRIBUFF_LVCMOS15D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS15U ------
 component TRIBUFF_LVCMOS15U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;

------ Component TRIBUFF_LVCMOS12 ------
 component TRIBUFF_LVCMOS12
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS12D ------
 component TRIBUFF_LVCMOS12D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS12U ------
 component TRIBUFF_LVCMOS12U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS18 ------
 component TRIBUFF_LVCMOS18
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS18D ------
 component TRIBUFF_LVCMOS18D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS18U ------
 component TRIBUFF_LVCMOS18U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS25 ------
 component TRIBUFF_LVCMOS25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS25D ------
 component TRIBUFF_LVCMOS25D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS25U ------
 component TRIBUFF_LVCMOS25U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS33 ------
 component TRIBUFF_LVCMOS33
    generic(
                TimingChecksOn:Boolean := True;
                Xon: Boolean := False;
                InstancePath: STRING :="*";
                MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

                tpd_D_PAD               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
                tipd_D          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_E          : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                D               : in    STD_ULOGIC;
                E               : in    STD_ULOGIC;
                PAD             : out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS33D ------
 component TRIBUFF_LVCMOS33D
    generic(
                TimingChecksOn:Boolean := True;
                Xon: Boolean := False;
                InstancePath: STRING :="*";
                MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

                tpd_D_PAD               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
                tipd_D          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_E          : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                D               : in    STD_ULOGIC;
                E               : in    STD_ULOGIC;
                PAD             : out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS33U ------
 component TRIBUFF_LVCMOS33U
    generic(
                TimingChecksOn:Boolean := True;
                Xon: Boolean := False;
                InstancePath: STRING :="*";
                MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

                tpd_D_PAD               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
                tipd_D          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_E          : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                D               : in    STD_ULOGIC;
                E               : in    STD_ULOGIC;
                PAD             : out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS5 ------
 component TRIBUFF_LVCMOS5
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS5D ------
 component TRIBUFF_LVCMOS5D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS5U ------
 component TRIBUFF_LVCMOS5U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;



component TRIBUFF_LVDS
    generic(
                TimingChecksOn:Boolean := True;
                Xon: Boolean := False;
                InstancePath: STRING :="*";
                MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

                tpd_D_PADP              : VitalDelayType01  := (0.100 ns, 0.100 ns);
                tpd_E_PADP              : VitalDelayType01Z := (0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns);
                tpd_D_PADN              : VitalDelayType01  := (0.100 ns, 0.100 ns);
                tpd_E_PADN              : VitalDelayType01Z := (0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns);
                tipd_D          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_E          : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                D               : in    STD_ULOGIC;
                E               : in    STD_ULOGIC;
                PADP            : out   STD_ULOGIC;
                PADN            : out   STD_ULOGIC);
end component;



------ Component TRIBUFF_PCI ------
 component TRIBUFF_PCI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_PCIX ------
 component TRIBUFF_PCIX
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_SSTL2_I ------
 component TRIBUFF_SSTL2_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_SSTL2_II ------
 component TRIBUFF_SSTL2_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_SSTL3_I ------
 component TRIBUFF_SSTL3_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_SSTL3_II ------
 component TRIBUFF_SSTL3_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_12 ------
 component TRIBUFF_S_12
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_12D ------
 component TRIBUFF_S_12D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_12U ------
 component TRIBUFF_S_12U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_16 ------
 component TRIBUFF_S_16
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_16D ------
 component TRIBUFF_S_16D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_16U ------
 component TRIBUFF_S_16U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_24 ------
 component TRIBUFF_S_24
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_24D ------
 component TRIBUFF_S_24D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_24U ------
 component TRIBUFF_S_24U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_8 ------
 component TRIBUFF_S_8
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_8D ------
 component TRIBUFF_S_8D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_8U ------
 component TRIBUFF_S_8U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component VCC ------
 component VCC
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True		);
    port(
		Y		: out    STD_ULOGIC);
 end component;


------ Component UJTAG ------
 component UJTAG
   generic(
      TimingChecksOn : Boolean := True;
      InstancePath   : STRING  := "*";
      Xon            : Boolean := False;
      MsgOn          : Boolean := True;

      tipd_UTDO      : VitalDelayType01 := (  0.0 ns,0.0 ns );
      tipd_TMS       : VitalDelayType01 := (  0.0 ns,0.0 ns );
      tipd_TDI       : VitalDelayType01 := (  0.0 ns,0.0 ns );
      tipd_TCK       : VitalDelayType01 := (  0.0 ns,0.0 ns );
      tipd_TRSTB     : VitalDelayType01 := (  0.0 ns,0.0 ns );

      tpd_TCK_UIREG0   : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_TCK_UIREG1   : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_TCK_UIREG2   : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_TCK_UIREG3   : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_TCK_UIREG4   : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_TCK_UIREG5   : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_TCK_UIREG6   : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_TCK_UIREG7   : VitalDelayType01 := (0.100 ns, 0.100 ns);

      tpd_TCK_URSTB    : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_TCK_UDRSH    : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_TCK_UDRCAP   : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_TCK_UDRUPD   : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_TCK_UDRCK    : VitalDelayType01 := (0.100 ns, 0.100 ns);

      tpd_TCK_TDO      : VitalDelayType01 := (0.100 ns, 0.100 ns);

      tpd_TRSTB_UIREG0 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_TRSTB_UIREG1 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_TRSTB_UIREG2 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_TRSTB_UIREG3 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_TRSTB_UIREG4 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_TRSTB_UIREG5 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_TRSTB_UIREG6 : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_TRSTB_UIREG7 : VitalDelayType01 := (0.100 ns, 0.100 ns);

      tpd_TRSTB_URSTB  : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_TRSTB_UDRSH  : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_TRSTB_UDRCAP : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_TRSTB_UDRUPD : VitalDelayType01 := (0.100 ns, 0.100 ns);

      tpd_TRSTB_TDO    : VitalDelayType01 := (0.100 ns, 0.100 ns);

      tpd_TDI_UTDI     : VitalDelayType01 := (0.100 ns, 0.100 ns);

      tsetup_TDI_TCK_posedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_TDI_TCK_negedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_TMS_TCK_posedge_posedge  : VitalDelayType := 0.000 ns;
      tsetup_TMS_TCK_negedge_posedge  : VitalDelayType := 0.000 ns;

      tsetup_UTDO_TCK_posedge_negedge : VitalDelayType := 0.000 ns;
      tsetup_UTDO_TCK_negedge_negedge : VitalDelayType := 0.000 ns;

      thold_TDI_TCK_posedge_posedge   : VitalDelayType := 0.000 ns;
      thold_TDI_TCK_negedge_posedge   : VitalDelayType := 0.000 ns;
      thold_TMS_TCK_posedge_posedge   : VitalDelayType := 0.000 ns;
      thold_TMS_TCK_negedge_posedge   : VitalDelayType := 0.000 ns;

      thold_UTDO_TCK_posedge_negedge  : VitalDelayType := 0.000 ns;
      thold_UTDO_TCK_negedge_negedge  : VitalDelayType := 0.000 ns;

      trecovery_TRSTB_TCK_posedge_posedge : VitalDelayType := 0.000 ns;
      thold_TRSTB_TCK_posedge_posedge     : VitalDelayType := 0.000 ns;

      tpw_TCK_posedge   : VitalDelayType := 0.000 ns;
      tpw_TCK_negedge   : VitalDelayType := 0.000 ns;
      tpw_TRSTB_negedge : VitalDelayType := 0.000 ns );

   port(
      UTDO           :  in    STD_ULOGIC;
      TMS            :  in    STD_ULOGIC;
      TDI            :  in    STD_ULOGIC;
      TCK            :  in    STD_ULOGIC;
      TRSTB          :  in    STD_ULOGIC;
      UIREG0         :  out   STD_ULOGIC;
      UIREG1         :  out   STD_ULOGIC;
      UIREG2         :  out   STD_ULOGIC;
      UIREG3         :  out   STD_ULOGIC;
      UIREG4         :  out   STD_ULOGIC;
      UIREG5         :  out   STD_ULOGIC;
      UIREG6         :  out   STD_ULOGIC;
      UIREG7         :  out   STD_ULOGIC;
      UTDI           :  out   STD_ULOGIC;
      URSTB          :  out   STD_ULOGIC;
      UDRCK          :  out   STD_ULOGIC;
      UDRCAP         :  out   STD_ULOGIC;
      UDRSH          :  out   STD_ULOGIC;
      UDRUPD         :  out   STD_ULOGIC;
      TDO            :  out   STD_ULOGIC);

 end component;

------ Component XA1 ------
 component XA1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XA1A ------
 component XA1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XA1B ------
 component XA1B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XA1C ------
 component XA1C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XAI1 ------
 component XAI1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XAI1A ------
 component XAI1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XNOR2 ------
 component XNOR2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XNOR3 ------
 component XNOR3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XO1 ------
 component XO1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XO1A ------
 component XO1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XOR2 ------
 component XOR2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XOR3 ------
 component XOR3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component ZOR3 ------
 component ZOR3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component ZOR3I ------
 component ZOR3I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BUFF ------
 component BUFF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKINT ------
 component CLKINT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOIN_IB ------
 component IOIN_IB
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_YIN_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_YIN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		YIN		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOIN_IRC ------
 component IOIN_IRC
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Y		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_YIN_ICLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		ICLK		:   in    STD_ULOGIC;
		YIN		:  in    STD_ULOGIC;
		Y		:  out    STD_ULOGIC);

 end component;


------ Component IOIN_IRP ------
 component IOIN_IRP
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Y		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_YIN_ICLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		ICLK		:   in    STD_ULOGIC;
		YIN		:  in    STD_ULOGIC;
		Y		:  out    STD_ULOGIC);

 end component;


------ Component IOIN_IREC ------
 component IOIN_IREC
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Y		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_YIN_ICLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_ICE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		ICE		:   in    STD_ULOGIC;
		ICLK		:   in    STD_ULOGIC;
		YIN		:  in    STD_ULOGIC;
		Y		:  out    STD_ULOGIC);

 end component;


------ Component IOIN_IREP ------
 component IOIN_IREP
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Y		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_YIN_ICLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		ICE		:   in    STD_ULOGIC;
		ICLK		:   in    STD_ULOGIC;
		YIN		:  in    STD_ULOGIC;
		Y		:  out    STD_ULOGIC);

 end component;


------ Component IOTRI_OB_EB ------
 component IOTRI_OB_EB
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_DOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_EOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		DOUT		: out    STD_ULOGIC;
		EOUT		: out    STD_ULOGIC);
 end component;


------ Component IOTRI_OB_ERC ------
 component IOTRI_OB_ERC
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_EOUT		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_DOUT		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		OCLK		:   in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		EOUT		:  out    STD_ULOGIC;
		DOUT		:  out    STD_ULOGIC);

 end component;


------ Component IOTRI_OB_ERP ------
 component IOTRI_OB_ERP
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_EOUT		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_DOUT		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		OCLK		:   in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		EOUT		:  out    STD_ULOGIC;
		DOUT		:  out    STD_ULOGIC);

 end component;


------ Component IOTRI_OB_EREC ------
 component IOTRI_OB_EREC
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_EOUT		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_DOUT		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_OCE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		OCE		:   in    STD_ULOGIC;
		OCLK		:   in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		EOUT		:  out    STD_ULOGIC;
		DOUT		:  out    STD_ULOGIC);

 end component;


------ Component IOTRI_OB_EREP ------
 component IOTRI_OB_EREP
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_EOUT		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_DOUT		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		OCE		:   in    STD_ULOGIC;
		OCLK		:   in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		EOUT		:  out    STD_ULOGIC;
		DOUT		:  out    STD_ULOGIC);

 end component;


------ Component IOTRI_ORC_EB ------
 component IOTRI_ORC_EB
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_DOUT		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_EOUT		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		OCLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		DOUT		:  out    STD_ULOGIC;
		EOUT		:  out    STD_ULOGIC);

 end component;


------ Component IOTRI_ORP_EB ------
 component IOTRI_ORP_EB
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_DOUT		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_EOUT		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		OCLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		DOUT		:  out    STD_ULOGIC;
		EOUT		:  out    STD_ULOGIC);

 end component;


------ Component IOTRI_OREC_EB ------
 component IOTRI_OREC_EB
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_DOUT		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_EOUT		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tipd_OCE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		OCE		:   in    STD_ULOGIC;
		OCLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		DOUT		:  out    STD_ULOGIC;
		EOUT		:  out    STD_ULOGIC);

 end component;


------ Component IOTRI_OREP_EB ------
 component IOTRI_OREP_EB
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_DOUT		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_EOUT		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		OCE		:   in    STD_ULOGIC;
		OCLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		DOUT		:  out    STD_ULOGIC;
		EOUT		:  out    STD_ULOGIC);

 end component;


------ Component IOTRI_ORC_ERC ------
 component IOTRI_ORC_ERC
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_posedge	:  VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC);
 end component;


------ Component IOTRI_OREC_EREC ------
 component IOTRI_OREC_EREC
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_posedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC);
 end component;


------ Component IOTRI_ORP_ERP ------
 component IOTRI_ORP_ERP
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_posedge	:  VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC);
 end component;


------ Component IOTRI_OREP_EREP ------
 component IOTRI_OREP_EREP
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_posedge	:  VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IB_OB_EB ------
 component IOBI_IB_OB_EB
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_DOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_EOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_YIN_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		YIN		: in    STD_ULOGIC;
		DOUT		: out    STD_ULOGIC;
		EOUT		: out    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOBI_IB_OB_ERC ------
 component IOBI_IB_OB_ERC
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_YIN_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_posedge	:  VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IB_OB_EREC ------
 component IOBI_IB_OB_EREC
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_YIN_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_posedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IB_OB_ERP ------
 component IOBI_IB_OB_ERP
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_YIN_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_posedge	:  VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IB_OB_EREP ------
 component IOBI_IB_OB_EREP
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_YIN_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_posedge	:  VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;

------ Component IOBI_IB_OD_EB ------
 component IOBI_IB_OD_EB
   generic (
      TimingChecksOn   : Boolean := True;
      InstancePath     : String  := "*";
      Xon              : Boolean := False;
      MsgOn            : Boolean := True;

      tipd_DR          : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DF          : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLR         : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E           : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_OCLK        : VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_YIN         : VitalDelayType01 := (0.000 ns, 0.000 ns);

      tpd_E_EOUT       : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_YIN_Y        : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_CLR_DOUT     : VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_OCLK_DOUT    : VitalDelayType01 := (0.100 ns, 0.100 ns);

      tsetup_DR_OCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DR_OCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
      tsetup_DR_OCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DR_OCLK_negedge_posedge      : VitalDelayType := 0.000 ns;

      tsetup_DF_OCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DF_OCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
      tsetup_DF_OCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
      thold_DF_OCLK_negedge_posedge      : VitalDelayType := 0.000 ns;

      trecovery_CLR_OCLK_negedge_posedge : VitalDelayType := 0.000 ns;
      thold_CLR_OCLK_negedge_posedge     : VitalDelayType := 0.000 ns;

      tpw_OCLK_posedge                   :  VitalDelayType := 0.000 ns;
      tpw_OCLK_negedge                   :  VitalDelayType := 0.000 ns;
      tperiod_OCLK_posedge               :  VitalDelayType := 0.000 ns;
      tpw_CLR_posedge                    :  VitalDelayType := 0.000 ns
     );


   port (
      DR            :  in    std_ulogic;
      DF            :  in    std_ulogic;
      CLR           :  in    std_ulogic;
      E             :  in    std_ulogic;
      OCLK          :  in    std_ulogic;
      YIN           :  in    std_ulogic;
      DOUT          :  out   std_ulogic;
      EOUT          :  out   std_ulogic;
      Y             :  out   std_ulogic
     );
 end component;

------ Component IOBI_IB_ORC_EB ------
 component IOBI_IB_ORC_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_YIN_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_posedge	:  VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IB_OREC_EB ------
 component IOBI_IB_OREC_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_YIN_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_posedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IB_ORP_EB ------
 component IOBI_IB_ORP_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_YIN_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_posedge	:  VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IB_OREP_EB ------
 component IOBI_IB_OREP_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_YIN_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_posedge	:  VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IB_ORC_ERC ------
 component IOBI_IB_ORC_ERC
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_YIN_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_posedge	:  VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IB_OREC_EREC ------
 component IOBI_IB_OREC_EREC
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_YIN_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_posedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IB_ORP_ERP ------
 component IOBI_IB_ORP_ERP
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_YIN_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_posedge	:  VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IB_OREP_EREP ------
 component IOBI_IB_OREP_EREP
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_YIN_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_posedge	:  VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IRC_OB_EB ------
 component IOBI_IRC_OB_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_posedge	:  VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IREC_OB_EB ------
 component IOBI_IREC_OB_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_posedge	:  VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                ICE         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IRP_OB_EB ------
 component IOBI_IRP_OB_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_posedge	:  VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IREP_OB_EB ------
 component IOBI_IREP_OB_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		trecovery_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_posedge	:  VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                ICE         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IRC_OB_ERC ------
 component IOBI_IRC_OB_ERC
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IREC_OB_ERC ------
 component IOBI_IREC_OB_ERC
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                ICE         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IRC_OB_EREC ------
 component IOBI_IRC_OB_EREC
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IREC_OB_EREC ------
 component IOBI_IREC_OB_EREC
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                ICE         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IRP_OB_ERP ------
 component IOBI_IRP_OB_ERP
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IREP_OB_ERP ------
 component IOBI_IREP_OB_ERP
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                ICE         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IRP_OB_EREP ------
 component IOBI_IRP_OB_EREP
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IREP_OB_EREP ------
 component IOBI_IREP_OB_EREP
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                ICE         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IRC_ORC_EB ------
 component IOBI_IRC_ORC_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IREC_ORC_EB ------
 component IOBI_IREC_ORC_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                ICE         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IRC_OREC_EB ------
 component IOBI_IRC_OREC_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IREC_OREC_EB ------
 component IOBI_IREC_OREC_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                ICE         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IRP_ORP_EB ------
 component IOBI_IRP_ORP_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IRP_OREP_EB ------
 component IOBI_IRP_OREP_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IREP_ORP_EB ------
 component IOBI_IREP_ORP_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                ICE         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IREP_OREP_EB ------
 component IOBI_IREP_OREP_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                ICE         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IRC_ORC_ERC ------
 component IOBI_IRC_ORC_ERC
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IRC_OREC_EREC ------
 component IOBI_IRC_OREC_EREC
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IREC_ORC_ERC ------
 component IOBI_IREC_ORC_ERC
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                ICE         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IREC_OREC_EREC ------
 component IOBI_IREC_OREC_EREC
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                ICE         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IRP_ORP_ERP ------
 component IOBI_IRP_ORP_ERP
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IRP_OREP_EREP ------
 component IOBI_IRP_OREP_EREP
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IREP_ORP_ERP ------
 component IOBI_IREP_ORP_ERP
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                ICE         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IREP_OREP_EREP ------
 component IOBI_IREP_OREP_EREP
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		trecovery_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_OCLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_posedge	:  VitalDelayType := 0.000 ns;
		trecovery_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_ICLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                ICE         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOPAD_IN ------
 component IOPAD_IN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


component IOPADP_BI
    generic(
       TimingChecksOn : Boolean  := True;
       Xon            : Boolean  := False;
       InstancePath   : STRING   := "*";
       MsgOn          : Boolean  := True;

                tpw_D_posedge     : VitalDelayType    := 0.000 ns;
                tpw_D_negedge     : VitalDelayType    := 0.000 ns;
                tpw_E_posedge     : VitalDelayType    := 0.000 ns;
                tpw_E_negedge     : VitalDelayType    := 0.000 ns;
                tpw_PAD_negedge   : VitalDelayType    := 0.000 ns;
                tpw_PAD_posedge   : VitalDelayType    := 0.000 ns;
                tpw_N2PIN_negedge : VitalDelayType    := 0.000 ns;
                tpw_N2PIN_posedge : VitalDelayType    := 0.000 ns;

                tpd_D_PAD         : VitalDelayType01  := (0.100 ns, 0.100 ns);
                tpd_E_PAD         : VitalDelayType01Z := (0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns);
                tpd_PAD_Y         : VitalDelayType01  := (0.100 ns, 0.100 ns);
                tpd_N2PIN_Y       : VitalDelayType01  := (0.100 ns, 0.100 ns);
                tpd_D_Y           : VitalDelayType01  := (0.100 ns, 0.100 ns);
                tpd_E_Y           : VitalDelayType01  := (0.100 ns, 0.100 ns);

                tipd_D            : VitalDelayType01  := (0.000 ns, 0.000 ns);
                tipd_E            : VitalDelayType01  := (0.000 ns, 0.000 ns);
                tipd_PAD          : VitalDelayType01  := (0.000 ns, 0.000 ns);
                tipd_N2PIN        : VitalDelayType01  := (0.000 ns, 0.000 ns));


    port(
                D               : in    STD_ULOGIC;
                E               : in    STD_ULOGIC;
                N2PIN           : in    STD_ULOGIC;
                PAD             : inout STD_ULOGIC;
                Y               : out   STD_ULOGIC);
end component;


 ------ Component IOPADP_IN ------
component IOPADP_IN
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      
      tpw_PAD_posedge 		: VitalDelayType := 0.000 ns;
      tpw_PAD_negedge           : VitalDelayType := 0.000 ns;
      tpw_N2PIN_posedge 	: VitalDelayType := 0.000 ns;
      tpw_N2PIN_negedge         : VitalDelayType := 0.000 ns;   

      tpd_PAD_Y                 :        VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_N2PIN_Y               :        VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_PAD         	     :        VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_N2PIN       	     :        VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PAD                            :        in    STD_ULOGIC;
      N2PIN                          :        in    STD_ULOGIC;
      Y                              :        out   STD_ULOGIC);

end component;


component IOPADN_BI
    generic(
       TimingChecksOn : Boolean  := True;
       Xon            : Boolean  := False;
       InstancePath   : STRING   := "*";
       MsgOn          : Boolean  := True;

                tpw_DB_posedge    : VitalDelayType    := 0.000 ns;
                tpw_DB_negedge    : VitalDelayType    := 0.000 ns;
                tpw_E_posedge     : VitalDelayType    := 0.000 ns;
                tpw_E_negedge     : VitalDelayType    := 0.000 ns;
                tpw_PAD_negedge   : VitalDelayType    := 0.000 ns;
                tpw_PAD_posedge   : VitalDelayType    := 0.000 ns;

                tpd_DB_PAD        : VitalDelayType01  := (0.100 ns, 0.100 ns);
                tpd_E_PAD         : VitalDelayType01Z := (0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns);
                tpd_PAD_N2POUT    : VitalDelayType01  := (0.100 ns, 0.100 ns);

                tipd_DB           : VitalDelayType01  := (0.000 ns, 0.000 ns);
                tipd_E            : VitalDelayType01  := (0.000 ns, 0.000 ns);
                tipd_PAD          : VitalDelayType01  := (0.000 ns, 0.000 ns));


    port(
                DB              : in    STD_ULOGIC;
                E               : in    STD_ULOGIC;
                PAD             : inout STD_ULOGIC;
                N2POUT          : out   STD_ULOGIC);
end component;


------ Component IOPADN_IN ------
component IOPADN_IN 
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      
      tpw_PAD_posedge 		: VitalDelayType := 0.000 ns;
      tpw_PAD_negedge           : VitalDelayType := 0.000 ns;
 
      tpd_PAD_N2POUT                 :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_PAD                       	     :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PAD                            :	in    STD_ULOGIC;
      N2POUT                         :	out   STD_ULOGIC);

end component;

------ Component IOPAD_TRI ------
 component IOPAD_TRI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpw_D_posedge	: VitalDelayType := 0.000 ns;
		tpw_D_negedge	: VitalDelayType := 0.000 ns;
		tpw_E_posedge   : VitalDelayType := 0.000 ns;
		tpw_E_negedge	: VitalDelayType := 0.000 ns;

		tpd_D_PAD       : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;

------ Component IOPADP_TRI ------
component IOPADP_TRI 
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpw_E_posedge           : VitalDelayType := 0.000 ns;
      tpw_E_negedge           : VitalDelayType := 0.000 ns;
      tpw_D_posedge           : VitalDelayType := 0.000 ns;
      tpw_D_negedge           : VitalDelayType := 0.000 ns;
      
      tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
      tpd_D_PAD                      :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      PAD                            :	out   STD_ULOGIC);

end component;

------ Component IOPADN_TRI ------
component IOPADN_TRI 
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      
      tpw_DB_posedge 	    :   VitalDelayType := 0.000 ns;
      tpw_DB_negedge            :   VitalDelayType := 0.000 ns;
      tpw_E_posedge 		: VitalDelayType := 0.000 ns;
      tpw_E_negedge           : VitalDelayType := 0.000 ns;

      tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
      tpd_DB_PAD                      :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_DB                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      DB                             :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      PAD                            :	out   STD_ULOGIC);

end component;

------ Component IOPAD_BI ------
 component IOPAD_BI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		
                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;
  
                tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;

------ Component IOPAD_IN_U ------
 component IOPAD_IN_U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpw_PAD_posedge		: VitalDelayType := 0.000 ns;
		tpw_PAD_negedge		: VitalDelayType := 0.000 ns;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOPAD_IN_D ------
 component IOPAD_IN_D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpw_PAD_posedge		: VitalDelayType := 0.000 ns;
		tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOPAD_TRI_U ------
 component IOPAD_TRI_U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpw_D_posedge	: VitalDelayType := 0.000 ns;
		tpw_D_negedge	: VitalDelayType := 0.000 ns;
		tpw_E_posedge	: VitalDelayType := 0.000 ns;
		tpw_E_negedge       : VitalDelayType := 0.000 ns;
		
                tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component IOPAD_TRI_D ------
 component IOPAD_TRI_D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpw_D_posedge	: VitalDelayType := 0.000 ns;
	        tpw_D_negedge   : VitalDelayType := 0.000 ns;
		tpw_E_posedge   : VitalDelayType := 0.000 ns;
                tpw_E_negedge 	: VitalDelayType := 0.000 ns;

                tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;

------ Component IOPAD_BI_U ------
 component IOPAD_BI_U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

		tpw_D_posedge	    : VitalDelayType := 0.000 ns;
	        tpw_D_negedge       : VitalDelayType := 0.000 ns;
		tpw_E_posedge       : VitalDelayType := 0.000 ns;
                tpw_E_negedge 	    : VitalDelayType := 0.000 ns;
		tpw_PAD_posedge     : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge     : VitalDelayType := 0.000 ns;

                tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);

		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOPAD_BI_D ------
 component IOPAD_BI_D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
	
		tpw_E_posedge       : VitalDelayType := 0.000 ns;
                tpw_E_negedge 	    : VitalDelayType := 0.000 ns;
		tpw_D_posedge       : VitalDelayType := 0.000 ns;
                tpw_D_negedge 	    : VitalDelayType := 0.000 ns;
		tpw_PAD_posedge     : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge     : VitalDelayType := 0.000 ns;

        	tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;

------ Component IOPADN_OUT ------
 component IOPADN_OUT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
                tpw_DB_posedge 	: VitalDelayType := 0.000 ns;
                tpw_DB_negedge  : VitalDelayType := 0.000 ns;
		tpd_DB_PAD      : VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;

------ Component BIBUF_F_2 ------
 component BIBUF_F_2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_2D ------
 component BIBUF_F_2D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_2U ------
 component BIBUF_F_2U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_4 ------
 component BIBUF_F_4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_4D ------
 component BIBUF_F_4D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_4U ------
 component BIBUF_F_4U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_6 ------
 component BIBUF_F_6
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_6D ------
 component BIBUF_F_6D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_6U ------
 component BIBUF_F_6U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_GTL33 ------
 component BIBUF_GTL33
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_GTL25 ------
 component BIBUF_GTL25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_HSTL_II ------
 component BIBUF_HSTL_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_2 ------
 component BIBUF_S_2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_2D ------
 component BIBUF_S_2D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_2U ------
 component BIBUF_S_2U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_4 ------
 component BIBUF_S_4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_4D ------
 component BIBUF_S_4D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_4U ------
 component BIBUF_S_4U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_6 ------
 component BIBUF_S_6
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_6D ------
 component BIBUF_S_6D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_6U ------
 component BIBUF_S_6U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_GTL25 ------
 component CLKBUF_GTL25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_GTL33 ------
 component CLKBUF_GTL33
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_HSTL_II ------
 component CLKBUF_HSTL_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_GTL33 ------
 component INBUF_GTL33
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_GTL25 ------
 component INBUF_GTL25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_HSTL_II ------
 component INBUF_HSTL_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_F_2 ------
 component OUTBUF_F_2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_F_4 ------
 component OUTBUF_F_4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_F_6 ------
 component OUTBUF_F_6
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_GTL25 ------
 component OUTBUF_GTL25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_GTL33 ------
 component OUTBUF_GTL33
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_HSTL_II ------
 component OUTBUF_HSTL_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_S_2 ------
 component OUTBUF_S_2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_S_4 ------
 component OUTBUF_S_4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_S_6 ------
 component OUTBUF_S_6
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_2 ------
 component TRIBUFF_F_2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_2D ------
 component TRIBUFF_F_2D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_2U ------
 component TRIBUFF_F_2U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_4 ------
 component TRIBUFF_F_4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_4D ------
 component TRIBUFF_F_4D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_4U ------
 component TRIBUFF_F_4U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_6 ------
 component TRIBUFF_F_6
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_6D ------
 component TRIBUFF_F_6D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_6U ------
 component TRIBUFF_F_6U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_GTL25 ------
 component TRIBUFF_GTL25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_GTL33 ------
 component TRIBUFF_GTL33
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_HSTL_II ------
 component TRIBUFF_HSTL_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_2 ------
 component TRIBUFF_S_2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_2D ------
 component TRIBUFF_S_2D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_2U ------
 component TRIBUFF_S_2U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_4 ------
 component TRIBUFF_S_4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_4D ------
 component TRIBUFF_S_4D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_4U ------
 component TRIBUFF_S_4U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_6 ------
 component TRIBUFF_S_6
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_6D ------
 component TRIBUFF_S_6D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_6U ------
 component TRIBUFF_S_6U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component BUFD ------
 component BUFD
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INVD ------
 component INVD
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOIN_IR ------
 component IOIN_IR
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_ICLK_Y		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_YIN_ICLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_YIN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		ICLK		:   in    STD_ULOGIC;
		YIN		:  in    STD_ULOGIC;
		Y		:  out    STD_ULOGIC);

 end component;


------ Component IOIN_IRE ------
 component IOIN_IRE
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_ICLK_Y		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_YIN_ICLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_ICE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		ICE		:   in    STD_ULOGIC;
		ICLK		:   in    STD_ULOGIC;
		YIN		:  in    STD_ULOGIC;
		Y		:  out    STD_ULOGIC);

 end component;


------ Component IOTRI_OB_ER ------
 component IOTRI_OB_ER
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_EOUT		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_DOUT		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		OCLK		:   in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		EOUT		:  out    STD_ULOGIC;
		DOUT		:  out    STD_ULOGIC);

 end component;


------ Component IOTRI_OB_ERE ------
 component IOTRI_OB_ERE
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_EOUT		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_DOUT		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_OCE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		OCE		:   in    STD_ULOGIC;
		OCLK		:   in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		EOUT		:  out    STD_ULOGIC;
		DOUT		:  out    STD_ULOGIC);

 end component;


------ Component IOTRI_OR_EB ------
 component IOTRI_OR_EB
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_DOUT		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_EOUT		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		OCLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		DOUT		:  out    STD_ULOGIC;
		EOUT		:  out    STD_ULOGIC);

 end component;


------ Component IOTRI_ORE_EB ------
 component IOTRI_ORE_EB
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_DOUT		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_EOUT		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_OCE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		OCE		:   in    STD_ULOGIC;
		OCLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		DOUT		:  out    STD_ULOGIC;
		EOUT		:  out    STD_ULOGIC);

 end component;


------ Component IOTRI_ORE_ERE ------
 component IOTRI_ORE_ERE
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC);
 end component;


------ Component IOTRI_OR_ER ------
 component IOTRI_OR_ER
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IB_OB_ER ------
 component IOBI_IB_OB_ER
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_YIN_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IB_OB_ERE ------
 component IOBI_IB_OB_ERE
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_YIN_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IB_OR_EB ------
 component IOBI_IB_OR_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_Yin_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_Yin :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                Yin         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IB_ORE_EB ------
 component IOBI_IB_ORE_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_YIN_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IB_OR_ER ------
 component IOBI_IB_OR_ER
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_YIN_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                YIN         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                Y                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IB_ORE_ERE ------
 component IOBI_IB_ORE_ERE
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_YIN_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                YIN         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                Y                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IR_OB_EB ------
 component IOBI_IR_OB_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IRE_OB_EB ------
 component IOBI_IRE_OB_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                ICE         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IR_OB_ER ------
 component IOBI_IR_OB_ER
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IRE_OB_ER ------
 component IOBI_IRE_OB_ER
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                ICE         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IR_OB_ERE ------
 component IOBI_IR_OB_ERE
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IRE_OB_ERE ------
 component IOBI_IRE_OB_ERE
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_D_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                ICE         : in    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IR_OR_EB ------
 component IOBI_IR_OR_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IRE_OR_EB ------
 component IOBI_IRE_OR_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                ICE         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IR_ORE_EB ------
 component IOBI_IR_ORE_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IRE_ORE_EB ------
 component IOBI_IRE_ORE_EB
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_E_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                ICE         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IR_OR_ER ------
 component IOBI_IR_OR_ER
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IR_ORE_ERE ------
 component IOBI_IR_ORE_ERE
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IRE_OR_ER ------
 component IOBI_IRE_OR_ER
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                ICE         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component IOBI_IRE_ORE_ERE ------
 component IOBI_IRE_ORE_ERE
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_OCLK_EOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_OCLK_DOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_ICLK_Y	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_E_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_OCLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_OCLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_OCE_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_OCE_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_OCLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_OCLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_OCLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_YIN_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_YIN_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tpw_ICLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_ICLK_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_ICE_ICLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_ICE_ICLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_OCE :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_YIN :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_ICE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                E         : in    STD_ULOGIC;
                OCLK         : in    STD_ULOGIC;
                OCE         : in    STD_ULOGIC;
                D         : in    STD_ULOGIC;
                YIN         : in    STD_ULOGIC;
                ICLK         : in    STD_ULOGIC;
                ICE         : in    STD_ULOGIC;
                EOUT                : out    STD_ULOGIC;
                DOUT                : out    STD_ULOGIC;
                Y                : out    STD_ULOGIC);
 end component;


------ Component CLKIO ------
 component CLKIO
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBIBUF ------
 component CLKBIBUF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;

------ Component PLLINT ------
component PLLINT 
    generic(
                TimingChecksOn:Boolean := True;
                Xon: Boolean := False;
                InstancePath: STRING :="*";
                MsgOn: Boolean := True;
                tpd_A_Y         : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_A          : VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                A               : in    STD_ULOGIC;
                Y               : out    STD_ULOGIC);
end component;

------ Component UFROM ------
component UFROM 
  generic (
        TimingChecksOn: Boolean := True;
        InstancePath  : String  := "*";
        Xon           : Boolean := False;
        MsgOn         : Boolean := True;
        MEMORYFILE    : String;
        DATA_X        : Integer := 1;
        ACT_PROGFILE      : String  := "";

        tipd_ADDR0    : VitalDelayType01 := ( 0.000 ns, 0.000 ns );
        tipd_ADDR1    : VitalDelayType01 := ( 0.000 ns, 0.000 ns );
        tipd_ADDR2    : VitalDelayType01 := ( 0.000 ns, 0.000 ns );
        tipd_ADDR3    : VitalDelayType01 := ( 0.000 ns, 0.000 ns );
        tipd_ADDR4    : VitalDelayType01 := ( 0.000 ns, 0.000 ns );
        tipd_ADDR5    : VitalDelayType01 := ( 0.000 ns, 0.000 ns );
        tipd_ADDR6    : VitalDelayType01 := ( 0.000 ns, 0.000 ns );
        tipd_CLK      : VitalDelayType01 := ( 0.000 ns, 0.000 ns );

        tpd_CLK_DO7   : VitalDelayType01 := ( 0.100 ns, 0.100 ns );
        tpd_CLK_DO6   : VitalDelayType01 := ( 0.100 ns, 0.100 ns );
        tpd_CLK_DO5   : VitalDelayType01 := ( 0.100 ns, 0.100 ns );
        tpd_CLK_DO4   : VitalDelayType01 := ( 0.100 ns, 0.100 ns );
        tpd_CLK_DO3   : VitalDelayType01 := ( 0.100 ns, 0.100 ns );
        tpd_CLK_DO2   : VitalDelayType01 := ( 0.100 ns, 0.100 ns );
        tpd_CLK_DO1   : VitalDelayType01 := ( 0.100 ns, 0.100 ns );
        tpd_CLK_DO0   : VitalDelayType01 := ( 0.100 ns, 0.100 ns );

        tsetup_ADDR6_CLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_ADDR6_CLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_ADDR6_CLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_ADDR6_CLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        tsetup_ADDR5_CLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_ADDR5_CLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_ADDR5_CLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_ADDR5_CLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        tsetup_ADDR4_CLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_ADDR4_CLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_ADDR4_CLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_ADDR4_CLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        tsetup_ADDR3_CLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_ADDR3_CLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_ADDR3_CLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_ADDR3_CLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        tsetup_ADDR2_CLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_ADDR2_CLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_ADDR2_CLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_ADDR2_CLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        tsetup_ADDR1_CLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_ADDR1_CLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_ADDR1_CLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_ADDR1_CLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        tsetup_ADDR0_CLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_ADDR0_CLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_ADDR0_CLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_ADDR0_CLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        tpw_CLK_posedge                   : VitalDelayType := 0.000 ns;
        tpw_CLK_negedge                   : VitalDelayType := 0.000 ns
       );

  port (
        DO0   :  out Std_ulogic := 'X';
        DO1   :  out Std_ulogic := 'X';
        DO2   :  out Std_ulogic := 'X';
        DO3   :  out Std_ulogic := 'X';
        DO4   :  out Std_ulogic := 'X';
        DO5   :  out Std_ulogic := 'X';
        DO6   :  out Std_ulogic := 'X';
        DO7   :  out Std_ulogic := 'X';
        ADDR0 :  in  Std_ulogic := 'X';
        ADDR1 :  in  Std_ulogic := 'X';
        ADDR2 :  in  Std_ulogic := 'X';
        ADDR3 :  in  Std_ulogic := 'X';
        ADDR4 :  in  Std_ulogic := 'X';
        ADDR5 :  in  Std_ulogic := 'X';
        ADDR6 :  in  Std_ulogic := 'X';
        CLK   :  in  Std_ulogic := 'X'
       );
end component;

------ Component UFROMH ------
component UFROMH 
  generic (
        TimingChecksOn: Boolean := True;
        InstancePath  : String  := "*";
        Xon           : Boolean := False;
        MsgOn         : Boolean := True;
        MEMORYFILE    : String;
        DATA_X        : Integer := 1;
        ACT_PROGFILE      : String  := "";

        tipd_ADDR0    : VitalDelayType01 := ( 0.000 ns, 0.000 ns );
        tipd_ADDR1    : VitalDelayType01 := ( 0.000 ns, 0.000 ns );
        tipd_ADDR2    : VitalDelayType01 := ( 0.000 ns, 0.000 ns );
        tipd_ADDR3    : VitalDelayType01 := ( 0.000 ns, 0.000 ns );
        tipd_ADDR4    : VitalDelayType01 := ( 0.000 ns, 0.000 ns );
        tipd_ADDR5    : VitalDelayType01 := ( 0.000 ns, 0.000 ns );
        tipd_ADDR6    : VitalDelayType01 := ( 0.000 ns, 0.000 ns );
        tipd_CLK      : VitalDelayType01 := ( 0.000 ns, 0.000 ns );

        tpd_CLK_DO7   : VitalDelayType01 := ( 0.100 ns, 0.100 ns );
        tpd_CLK_DO6   : VitalDelayType01 := ( 0.100 ns, 0.100 ns );
        tpd_CLK_DO5   : VitalDelayType01 := ( 0.100 ns, 0.100 ns );
        tpd_CLK_DO4   : VitalDelayType01 := ( 0.100 ns, 0.100 ns );
        tpd_CLK_DO3   : VitalDelayType01 := ( 0.100 ns, 0.100 ns );
        tpd_CLK_DO2   : VitalDelayType01 := ( 0.100 ns, 0.100 ns );
        tpd_CLK_DO1   : VitalDelayType01 := ( 0.100 ns, 0.100 ns );
        tpd_CLK_DO0   : VitalDelayType01 := ( 0.100 ns, 0.100 ns );

        tsetup_ADDR6_CLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_ADDR6_CLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_ADDR6_CLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_ADDR6_CLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        tsetup_ADDR5_CLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_ADDR5_CLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_ADDR5_CLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_ADDR5_CLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        tsetup_ADDR4_CLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_ADDR4_CLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_ADDR4_CLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_ADDR4_CLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        tsetup_ADDR3_CLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_ADDR3_CLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_ADDR3_CLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_ADDR3_CLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        tsetup_ADDR2_CLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_ADDR2_CLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_ADDR2_CLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_ADDR2_CLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        tsetup_ADDR1_CLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_ADDR1_CLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_ADDR1_CLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_ADDR1_CLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        tsetup_ADDR0_CLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_ADDR0_CLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_ADDR0_CLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_ADDR0_CLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        tpw_CLK_posedge                   : VitalDelayType := 0.000 ns;
        tpw_CLK_negedge                   : VitalDelayType := 0.000 ns
       );

  port (
        DO0   :  out Std_ulogic := 'X';
        DO1   :  out Std_ulogic := 'X';
        DO2   :  out Std_ulogic := 'X';
        DO3   :  out Std_ulogic := 'X';
        DO4   :  out Std_ulogic := 'X';
        DO5   :  out Std_ulogic := 'X';
        DO6   :  out Std_ulogic := 'X';
        DO7   :  out Std_ulogic := 'X';
        ADDR0 :  in  Std_ulogic := 'X';
        ADDR1 :  in  Std_ulogic := 'X';
        ADDR2 :  in  Std_ulogic := 'X';
        ADDR3 :  in  Std_ulogic := 'X';
        ADDR4 :  in  Std_ulogic := 'X';
        ADDR5 :  in  Std_ulogic := 'X';
        ADDR6 :  in  Std_ulogic := 'X';
        CLK   :  in  Std_ulogic := 'X'
       );
end component;

------ Component ULSICC ------
component ULSICC

    generic(
                TimingChecksOn:Boolean := True;
                Xon: Boolean := False;
                InstancePath: STRING :="*";
                MsgOn: Boolean := True;
                tipd_LSICC          : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                LSICC           : in    STD_ULOGIC);
end component;


------ Component ULSICC_INT ------
component ULSICC_INT

    generic(
                TimingChecksOn:Boolean := True;
                Xon: Boolean := False;
                InstancePath: STRING :="*";
                MsgOn: Boolean := True;
                tipd_USTDBY         : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_LPENA          : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                USTDBY          : in    STD_ULOGIC;
                LPENA           : in    STD_ULOGIC);
end component;

------ Component ULSICC_AUTH ------
component ULSICC_AUTH 

    generic(
                TimingChecksOn:Boolean := True;
                Xon: Boolean := False;
                InstancePath: STRING :="*";
                MsgOn: Boolean := True;
                tipd_AUTHEN         : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_LSICC          : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                AUTHEN          : in    STD_ULOGIC;
                LSICC           : in    STD_ULOGIC);
end component;

------ Component SIMBUF ------
COMPONENT SIMBUF
    PORT(
                D         : in    STD_ULOGIC;
               PAD                : out    STD_ULOGIC);
END COMPONENT;

end COMPONENTS;

--------------------- END OF COMPONENTS PACKAGE SECTION  ----------------


library IEEE;
use IEEE.STD_LOGIC_1164.all;

use IEEE.VITAL_Timing.all;
use IEEE.VITAL_Primitives.all;

package VTABLES is

   CONSTANT L : VitalTableSymbolType := '0';
   CONSTANT H : VitalTableSymbolType := '1';
   CONSTANT x : VitalTableSymbolType := '-';
   CONSTANT S : VitalTableSymbolType := 'S';
   CONSTANT R : VitalTableSymbolType := '/';
   CONSTANT U : VitalTableSymbolType := 'X';
   CONSTANT V : VitalTableSymbolType := 'B'; -- valid clock signal (non-rising)

-- CLR_ipd, CLK_delayed, Q_zd, D, E_delayed, PRE_ipd, CLK_ipd
CONSTANT DFEG_Q_tab : VitalStateTableType := (
( L,  x,  x,  x,  x,  x,  x,  x,  L ),
( H,  L,  H,  H,  x,  x,  H,  x,  H ),
( H,  L,  H,  x,  H,  x,  H,  x,  H ),
( H,  L,  x,  H,  L,  x,  H,  x,  H ),
( H,  H,  x,  x,  x,  H,  x,  x,  S ),
( H,  x,  x,  x,  x,  L,  x,  x,  H ),
( H,  x,  x,  x,  x,  H,  L,  x,  S ),
( x,  L,  L,  L,  x,  H,  H,  x,  L ),
( x,  L,  L,  x,  H,  H,  H,  x,  L ),
( x,  L,  x,  L,  L,  H,  H,  x,  L ),
( U,  x,  L,  x,  x,  H,  x,  x,  L ),
( H,  x,  H,  x,  x,  U,  x,  x,  H )); 

-- CLR_ipd, CLK_delayed, T_delayed, Q_zd, CLK_ipd
CONSTANT tflipflop_Q_tab : VitalStateTableType := (
( L,  x,  x,  x,  x,  x,  L ),
( H,  L,  L,  H,  H,  x,  H ),
( H,  L,  H,  L,  H,  x,  H ),
( H,  H,  x,  x,  x,  x,  S ),
( H,  x,  x,  x,  L,  x,  S ),
( x,  L,  L,  L,  H,  x,  L ),
( x,  L,  H,  H,  H,  x,  L ));

-- CLR_ipd, CLK_delayed, PRE_delayed,K_delayed,J_delayed, Q_zd, CLK_ipd
CONSTANT jkflipflop_Q_tab : VitalStateTableType := (
( L,  x,  H,  x,  x,  x,  x,  x,  U ),
( L,  x,  L,  x,  x,  x,  x,  x,  L ),
( H,  L,  x,  L,  H,  x,  H,  x,  H ),
( H,  L,  x,  L,  x,  H,  H,  x,  H ),
( H,  L,  x,  x,  H,  L,  H,  x,  H ),
( H,  H,  L,  x,  x,  x,  x,  x,  S ),
( H,  x,  L,  x,  x,  x,  L,  x,  S ),
( H,  x,  H,  x,  x,  x,  x,  x,  H ),
( x,  L,  L,  H,  L,  x,  H,  x,  L ),
( x,  L,  L,  H,  x,  H,  H,  x,  L ),
( x,  L,  L,  x,  L,  L,  H,  x,  L ),
( U,  x,  L,  x,  x,  L,  x,  x,  L ),
( H,  x,  U,  x,  x,  H,  x,  x,  H ));

CONSTANT JKF2A_Q_tab : VitalStateTableType := (
( L,  x,  x,  x,  x,  x,  x,  L ),
( H,  L,  L,  H,  x,  H,  x,  H ),
( H,  L,  L,  x,  H,  H,  x,  H ),
( H,  L,  x,  H,  L,  H,  x,  H ),
( H,  H,  x,  x,  x,  x,  x,  S ),
( H,  x,  x,  x,  x,  L,  x,  S ),
( x,  L,  H,  L,  x,  H,  x,  L ),
( x,  L,  H,  x,  H,  H,  x,  L ),
( x,  L,  x,  L,  L,  H,  x,  L ),
( U,  x,  x,  x,  L,  x,  x,  L ));

CONSTANT JKF3A_Q_tab : VitalStateTableType := (
( L,  H,  L,  x,  H,  H,  x,  L ),
( L,  H,  x,  H,  H,  H,  x,  L ),
( L,  L,  H,  x,  x,  H,  x,  H ),
( L,  L,  x,  H,  x,  H,  x,  H ),
( L,  x,  L,  L,  H,  H,  x,  L ),
( L,  x,  H,  L,  x,  H,  x,  H ),
( H,  x,  x,  x,  H,  x,  x,  S ),
( x,  x,  x,  x,  L,  x,  x,  H ),
( x,  x,  x,  x,  H,  L,  x,  S ),
( x,  x,  x,  H,  U,  x,  x,  H ));


CONSTANT dlatch_DLE3B_Q_tab : VitalStateTableType := (
( x,  x,  x,  H,  x,  H ),   --active high preset

( H,  x,  x,  L,  x,  S ),   --latch
( x,  H,  x,  L,  x,  S ),   --latch

( L,  L,  H,  L,  x,  H ),   --transparent
( L,  L,  L,  L,  x,  L ),   --transparent

( U,  x,  H,  L,  H,  H ),   --o/p mux pessimism
( x,  U,  H,  L,  H,  H ),   --o/p mux pessimism
( U,  x,  L,  L,  L,  L ),   --o/p mux pessimism
( x,  U,  L,  L,  L,  L ),   --o/p mux pessimism

( L,  L,  H,  U,  x,  H ),   --PRE==X
( H,  x,  x,  U,  H,  H ),   --PRE==X
( x,  H,  x,  U,  H,  H ),   --PRE==X
( L,  U,  H,  U,  H,  H ),   --PRE==X
( U,  L,  H,  U,  H,  H ),   --PRE==X
( U,  U,  H,  U,  H,  H ));  --PRE==X
--G, E, D, P, Qn, Qn+1

CONSTANT dlatch_DLE2B_Q_tab : VitalStateTableType := (
( L,  x,  x,  x,  x,  L ),   --active low clear

( H,  H,  x,  x,  x,  S ),   --latch
( H,  x,  H,  x,  x,  S ),   --latch

( H,  L,  L,  H,  x,  H ),   --transparent
( H,  L,  L,  L,  x,  L ),   --transparent

( H,  x,  x,  L,  L,  L ),   --o/p mux pessimism
( H,  x,  x,  H,  H,  H ),   --o/p mux pessimism

( U,  x,  x,  L,  L,  L ),   --CLR==X, o/p mux pessimism
( U,  H,  x,  x,  L,  L ),   --CLR==X, o/p mux pessimism, latch
( U,  x,  H,  x,  L,  L ),   --CLR==X, o/p mux pessimism, latch
( U,  L,  L,  L,  x,  L ));  --CLR==X, i/p mux pessimism
--C, G, E, D, Qn, Qn+1


CONSTANT dlatch_DL2C_Q_tab : VitalStateTableType := (
( L,  x,  x,  x,  x,  L ),   --active low clear
( H,  x,  x,  H,  x,  H ),   --active high preset

( H,  H,  x,  L,  x,  S ),   --latch
( H,  L,  L,  L,  x,  L ),   --transparent

( U,  L,  L,  L,  x,  L ),   --CLR==U
( U,  H,  x,  L,  L,  L ),   --CLR==U
( x,  U,  L,  L,  L,  L ),   --CLR,G==U

( H,  U,  H,  x,  H,  H ),   --PRE==U/x,G==U
( H,  L,  H,  x,  x,  H ),   --PRE==U/x
( H,  H,  x,  U,  H,  H ));   --PRE==U
--CLR, G, D, PRE, Qn, Qn+1

CONSTANT DFN1C1_Q_tab : VitalStateTableType := (
-- CLR_ipd, CLK_ipd, D_ipd, State,   Q
(      '1',     '-',    '-',  '-',  '0' ),
(      '0',     '/',    '1',  '-',  '1' ),
(      '-',     '/',    '0',  '-',  '0' ),
(      '0',     '/',    'X',  '-',  'X' ),
(      '-',     '/',    '0',  '0',  '0' ),
(      'X',     '/',    'X',  '-',  'X' ),
(      'X',     '/',    '1',  '-',  'X' ),
(      'X',     '-',    '-',  '0',  '0' ),
(      '0',     '-',    '-',  '-',  'S' ));

end VTABLES;



--------------------- END OF VITABLE TABLE SECTION  ----------------

 ---- CELL AND2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND2 :  entity is TRUE;
 end AND2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AND2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( A_ipd  AND  B_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND2_VITAL of AND2 is 
    for VITAL_ACT
    end for;
 end CFG_AND2_VITAL;



 ---- CELL AND2A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND2A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND2A :  entity is TRUE;
 end AND2A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AND2A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( (NOT A_ipd)  AND  B_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND2A_VITAL of AND2A is 
    for VITAL_ACT
    end for;
 end CFG_AND2A_VITAL;



 ---- CELL AND2B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND2B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND2B :  entity is TRUE;
 end AND2B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AND2B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( (NOT A_ipd)  AND  (NOT B_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND2B_VITAL of AND2B is 
    for VITAL_ACT
    end for;
 end CFG_AND2B_VITAL;



 ---- CELL AND3 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND3 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND3 :  entity is TRUE;
 end AND3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AND3 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  B_ipd ) AND  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND3_VITAL of AND3 is 
    for VITAL_ACT
    end for;
 end CFG_AND3_VITAL;



 ---- CELL AND3A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND3A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND3A :  entity is TRUE;
 end AND3A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AND3A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  B_ipd ) AND  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND3A_VITAL of AND3A is 
    for VITAL_ACT
    end for;
 end CFG_AND3A_VITAL;



 ---- CELL AND3B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND3B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND3B :  entity is TRUE;
 end AND3B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AND3B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND3B_VITAL of AND3B is 
    for VITAL_ACT
    end for;
 end CFG_AND3B_VITAL;



 ---- CELL AND3C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND3C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND3C :  entity is TRUE;
 end AND3C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AND3C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND3C_VITAL of AND3C is 
    for VITAL_ACT
    end for;
 end CFG_AND3C_VITAL;



 ---- CELL AO12 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO12 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO12 :  entity is TRUE;
 end AO12;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AO12 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( VitalMUX2( B_ipd ,( A_ipd  AND  (NOT B_ipd) ), (NOT C_ipd) ) OR (( (NOT A_ipd)  AND  B_ipd ) OR ( (NOT A_ipd)  AND  (NOT C_ipd) )));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO12_VITAL of AO12 is 
    for VITAL_ACT
    end for;
 end CFG_AO12_VITAL;



 ---- CELL AO13 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO13 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO13 :  entity is TRUE;
 end AO13;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AO13 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( A_ipd  AND  B_ipd ) OR ( A_ipd  AND  (NOT C_ipd) )) OR ( B_ipd  AND  (NOT C_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO13_VITAL of AO13 is 
    for VITAL_ACT
    end for;
 end CFG_AO13_VITAL;



 ---- CELL AO14 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO14 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO14 :  entity is TRUE;
 end AO14;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AO14 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( VitalMUX2(( (NOT A_ipd)  AND  (NOT B_ipd) ), B_ipd , C_ipd ) OR (( A_ipd  AND  B_ipd ) OR ( A_ipd  AND  (NOT C_ipd) )));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO14_VITAL of AO14 is 
    for VITAL_ACT
    end for;
 end CFG_AO14_VITAL;



 ---- CELL AO15 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO15 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO15 :  entity is TRUE;
 end AO15;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AO15 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( VitalMUX2(( A_ipd  AND  (NOT B_ipd) ),( (NOT A_ipd)  AND  (NOT B_ipd) ), C_ipd ) OR (( (NOT A_ipd)  AND  B_ipd ) AND  C_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO15_VITAL of AO15 is 
    for VITAL_ACT
    end for;
 end CFG_AO15_VITAL;



 ---- CELL AO16 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO16 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO16 :  entity is TRUE;
 end AO16;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AO16 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2(( A_ipd  AND  B_ipd ),( (NOT A_ipd)  AND  (NOT B_ipd) ), (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO16_VITAL of AO16 is 
    for VITAL_ACT
    end for;
 end CFG_AO16_VITAL;



 ---- CELL AO17 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO17 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO17 :  entity is TRUE;
 end AO17;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AO17 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( VitalMUX2(( (NOT A_ipd)  AND  (NOT B_ipd) ),( (NOT A_ipd)  AND  B_ipd ), C_ipd ) OR (( A_ipd  AND  B_ipd ) AND  C_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO17_VITAL of AO17 is 
    for VITAL_ACT
    end for;
 end CFG_AO17_VITAL;



 ---- CELL AO18 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO18 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO18 :  entity is TRUE;
 end AO18;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AO18 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  B_ipd ) OR ( (NOT A_ipd)  AND  (NOT C_ipd) )) OR ( B_ipd  AND  (NOT C_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO18_VITAL of AO18 is 
    for VITAL_ACT
    end for;
 end CFG_AO18_VITAL;



 ---- CELL AO1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO1 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO1 :  entity is TRUE;
 end AO1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AO1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  B_ipd ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO1_VITAL of AO1 is 
    for VITAL_ACT
    end for;
 end CFG_AO1_VITAL;



 ---- CELL AO1A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO1A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO1A :  entity is TRUE;
 end AO1A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AO1A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  B_ipd ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO1A_VITAL of AO1A is 
    for VITAL_ACT
    end for;
 end CFG_AO1A_VITAL;



 ---- CELL AO1B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO1B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO1B :  entity is TRUE;
 end AO1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AO1B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  B_ipd ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO1B_VITAL of AO1B is 
    for VITAL_ACT
    end for;
 end CFG_AO1B_VITAL;



 ---- CELL AO1C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO1C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO1C :  entity is TRUE;
 end AO1C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AO1C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  B_ipd ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO1C_VITAL of AO1C is 
    for VITAL_ACT
    end for;
 end CFG_AO1C_VITAL;



 ---- CELL AO1D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO1D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO1D :  entity is TRUE;
 end AO1D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AO1D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  (NOT B_ipd) ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO1D_VITAL of AO1D is 
    for VITAL_ACT
    end for;
 end CFG_AO1D_VITAL;



 ---- CELL AO1E ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO1E is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO1E :  entity is TRUE;
 end AO1E;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AO1E is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  (NOT B_ipd) ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO1E_VITAL of AO1E is 
    for VITAL_ACT
    end for;
 end CFG_AO1E_VITAL;



 ---- CELL AOI1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI1 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI1 :  entity is TRUE;
 end AOI1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AOI1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( A_ipd  AND  B_ipd ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI1_VITAL of AOI1 is 
    for VITAL_ACT
    end for;
 end CFG_AOI1_VITAL;



 ---- CELL AOI1A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI1A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI1A :  entity is TRUE;
 end AOI1A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AOI1A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT A_ipd)  AND  B_ipd ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI1A_VITAL of AOI1A is 
    for VITAL_ACT
    end for;
 end CFG_AOI1A_VITAL;



 ---- CELL AOI1B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI1B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI1B :  entity is TRUE;
 end AOI1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AOI1B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( A_ipd  AND  B_ipd ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI1B_VITAL of AOI1B is 
    for VITAL_ACT
    end for;
 end CFG_AOI1B_VITAL;



 ---- CELL AOI1C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI1C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI1C :  entity is TRUE;
 end AOI1C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AOI1C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT A_ipd)  AND  (NOT B_ipd) ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI1C_VITAL of AOI1C is 
    for VITAL_ACT
    end for;
 end CFG_AOI1C_VITAL;



 ---- CELL AOI1D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI1D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI1D :  entity is TRUE;
 end AOI1D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AOI1D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT A_ipd)  AND  (NOT B_ipd) ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI1D_VITAL of AOI1D is 
    for VITAL_ACT
    end for;
 end CFG_AOI1D_VITAL;



 ---- CELL AOI5 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI5 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI5 :  entity is TRUE;
 end AOI5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AOI5 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT VitalMUX2(( (NOT A_ipd)  AND  B_ipd ),( A_ipd  AND  (NOT B_ipd) ), C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI5_VITAL of AOI5 is 
    for VITAL_ACT
    end for;
 end CFG_AOI5_VITAL;



 ---- CELL AX1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AX1 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AX1 :  entity is TRUE;
 end AX1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AX1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  B_ipd ) XOR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AX1_VITAL of AX1 is 
    for VITAL_ACT
    end for;
 end CFG_AX1_VITAL;



 ---- CELL AX1A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AX1A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AX1A :  entity is TRUE;
 end AX1A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AX1A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT A_ipd)  AND  B_ipd ) XOR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AX1A_VITAL of AX1A is 
    for VITAL_ACT
    end for;
 end CFG_AX1A_VITAL;



 ---- CELL AX1B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AX1B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AX1B :  entity is TRUE;
 end AX1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AX1B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  (NOT B_ipd) ) XOR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AX1B_VITAL of AX1B is 
    for VITAL_ACT
    end for;
 end CFG_AX1B_VITAL;



 ---- CELL AX1C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AX1C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AX1C :  entity is TRUE;
 end AX1C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AX1C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  B_ipd ) XOR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AX1C_VITAL of AX1C is 
    for VITAL_ACT
    end for;
 end CFG_AX1C_VITAL;



 ---- CELL AX1D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AX1D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AX1D :  entity is TRUE;
 end AX1D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AX1D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT A_ipd)  AND  (NOT B_ipd) ) XOR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AX1D_VITAL of AX1D is 
    for VITAL_ACT
    end for;
 end CFG_AX1D_VITAL;



 ---- CELL AX1E ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AX1E is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AX1E :  entity is TRUE;
 end AX1E;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AX1E is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( A_ipd  AND  B_ipd ) XOR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AX1E_VITAL of AX1E is 
    for VITAL_ACT
    end for;
 end CFG_AX1E_VITAL;



 ---- CELL AXO1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXO1 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXO1 :  entity is TRUE;
 end AXO1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AXO1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( B_ipd  AND  (NOT C_ipd) ) OR  VitalMUX2( C_ipd , A_ipd , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXO1_VITAL of AXO1 is 
    for VITAL_ACT
    end for;
 end CFG_AXO1_VITAL;



 ---- CELL AXO2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXO2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXO2 :  entity is TRUE;
 end AXO2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AXO2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( B_ipd  AND  (NOT C_ipd) ) OR  VitalMUX2( C_ipd , (NOT A_ipd) , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXO2_VITAL of AXO2 is 
    for VITAL_ACT
    end for;
 end CFG_AXO2_VITAL;



 ---- CELL AXO3 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXO3 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXO3 :  entity is TRUE;
 end AXO3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AXO3 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT B_ipd)  AND  C_ipd ) OR  VitalMUX2( A_ipd , (NOT C_ipd) , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXO3_VITAL of AXO3 is 
    for VITAL_ACT
    end for;
 end CFG_AXO3_VITAL;



 ---- CELL AXO5 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXO5 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXO5 :  entity is TRUE;
 end AXO5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AXO5 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( B_ipd  AND  C_ipd ) OR  VitalMUX2( (NOT A_ipd) , (NOT C_ipd) , B_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXO5_VITAL of AXO5 is 
    for VITAL_ACT
    end for;
 end CFG_AXO5_VITAL;



 ---- CELL AXO6 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXO6 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXO6 :  entity is TRUE;
 end AXO6;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AXO6 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT B_ipd)  AND  (NOT C_ipd) ) OR  VitalMUX2( C_ipd , A_ipd , B_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXO6_VITAL of AXO6 is 
    for VITAL_ACT
    end for;
 end CFG_AXO6_VITAL;



 ---- CELL AXO7 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXO7 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXO7 :  entity is TRUE;
 end AXO7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AXO7 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT B_ipd)  AND  C_ipd ) OR  VitalMUX2( (NOT A_ipd) , (NOT C_ipd) , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXO7_VITAL of AXO7 is 
    for VITAL_ACT
    end for;
 end CFG_AXO7_VITAL;



 ---- CELL AXOI1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXOI1 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXOI1 :  entity is TRUE;
 end AXOI1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AXOI1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( B_ipd  AND  (NOT C_ipd) ) OR  VitalMUX2( C_ipd , A_ipd , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXOI1_VITAL of AXOI1 is 
    for VITAL_ACT
    end for;
 end CFG_AXOI1_VITAL;



 ---- CELL AXOI2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXOI2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXOI2 :  entity is TRUE;
 end AXOI2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AXOI2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( B_ipd  AND  (NOT C_ipd) ) OR  VitalMUX2( C_ipd , (NOT A_ipd) , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXOI2_VITAL of AXOI2 is 
    for VITAL_ACT
    end for;
 end CFG_AXOI2_VITAL;



 ---- CELL AXOI3 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXOI3 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXOI3 :  entity is TRUE;
 end AXOI3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AXOI3 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT B_ipd)  AND  C_ipd ) OR  VitalMUX2( A_ipd , (NOT C_ipd) , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXOI3_VITAL of AXOI3 is 
    for VITAL_ACT
    end for;
 end CFG_AXOI3_VITAL;



 ---- CELL AXOI4 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXOI4 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXOI4 :  entity is TRUE;
 end AXOI4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AXOI4 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( B_ipd  AND  C_ipd ) OR  VitalMUX2( A_ipd , (NOT C_ipd) , B_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXOI4_VITAL of AXOI4 is 
    for VITAL_ACT
    end for;
 end CFG_AXOI4_VITAL;



 ---- CELL AXOI5 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXOI5 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXOI5 :  entity is TRUE;
 end AXOI5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AXOI5 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( B_ipd  AND  C_ipd ) OR  VitalMUX2( (NOT A_ipd) , (NOT C_ipd) , B_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXOI5_VITAL of AXOI5 is 
    for VITAL_ACT
    end for;
 end CFG_AXOI5_VITAL;



 ---- CELL AXOI7 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXOI7 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXOI7 :  entity is TRUE;
 end AXOI7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of AXOI7 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT B_ipd)  AND  C_ipd ) OR  VitalMUX2( (NOT A_ipd) , (NOT C_ipd) , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXOI7_VITAL of AXOI7 is 
    for VITAL_ACT
    end for;
 end CFG_AXOI7_VITAL;



 ---- CELL BIBUF ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF :  entity is TRUE;
 end BIBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_VITAL of BIBUF is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_VITAL;



 ---- CELL BIBUF_F_12 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_12 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_12 :  entity is TRUE;
 end BIBUF_F_12;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_12 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_12",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_12",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_12",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_12_VITAL of BIBUF_F_12 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_12_VITAL;



 ---- CELL BIBUF_F_12D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_12D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_12D :  entity is TRUE;
 end BIBUF_F_12D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_12D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_12D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_12D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_12D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01LWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_12D_VITAL of BIBUF_F_12D is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_12D_VITAL;



 ---- CELL BIBUF_F_12U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_12U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_12U :  entity is TRUE;
 end BIBUF_F_12U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_12U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_12U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_12U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_12U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01HWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_12U_VITAL of BIBUF_F_12U is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_12U_VITAL;



 ---- CELL BIBUF_F_16 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_16 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_16 :  entity is TRUE;
 end BIBUF_F_16;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_16 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_16",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_16",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_16",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_16_VITAL of BIBUF_F_16 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_16_VITAL;



 ---- CELL BIBUF_F_16D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_16D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_16D :  entity is TRUE;
 end BIBUF_F_16D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_16D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_16D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_16D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_16D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01LWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_16D_VITAL of BIBUF_F_16D is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_16D_VITAL;



 ---- CELL BIBUF_F_16U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_16U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_16U :  entity is TRUE;
 end BIBUF_F_16U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_16U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_16U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_16U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_16U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01HWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_16U_VITAL of BIBUF_F_16U is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_16U_VITAL;



 ---- CELL BIBUF_F_24 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_24 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_24 :  entity is TRUE;
 end BIBUF_F_24;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_24 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_24",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_24",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_24",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_24_VITAL of BIBUF_F_24 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_24_VITAL;



 ---- CELL BIBUF_F_24D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_24D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_24D :  entity is TRUE;
 end BIBUF_F_24D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_24D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_24D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_24D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_24D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01LWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_24D_VITAL of BIBUF_F_24D is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_24D_VITAL;



 ---- CELL BIBUF_F_24U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_24U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_24U :  entity is TRUE;
 end BIBUF_F_24U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_24U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_24U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_24U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_24U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01HWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_24U_VITAL of BIBUF_F_24U is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_24U_VITAL;



 ---- CELL BIBUF_F_8 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_8 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_8 :  entity is TRUE;
 end BIBUF_F_8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_8 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_8",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_8",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_8",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_8_VITAL of BIBUF_F_8 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_8_VITAL;



 ---- CELL BIBUF_F_8D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_8D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_8D :  entity is TRUE;
 end BIBUF_F_8D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_8D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_8D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_8D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_8D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01LWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_8D_VITAL of BIBUF_F_8D is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_8D_VITAL;



 ---- CELL BIBUF_F_8U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_8U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_8U :  entity is TRUE;
 end BIBUF_F_8U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_8U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_8U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_8U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_F_8U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01HWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_8U_VITAL of BIBUF_F_8U is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_8U_VITAL;



 ---- CELL BIBUF_GTLP25 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_GTLP25 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_GTLP25 :  entity is TRUE;
 end BIBUF_GTLP25;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_GTLP25 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_GTLP25",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_GTLP25",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_GTLP25",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_GTLP25_VITAL of BIBUF_GTLP25 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_GTLP25_VITAL;



 ---- CELL BIBUF_GTLP33 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_GTLP33 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_GTLP33 :  entity is TRUE;
 end BIBUF_GTLP33;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_GTLP33 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_GTLP33",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_GTLP33",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_GTLP33",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_GTLP33_VITAL of BIBUF_GTLP33 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_GTLP33_VITAL;



 ---- CELL BIBUF_HSTL_I ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_HSTL_I is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_HSTL_I :  entity is TRUE;
 end BIBUF_HSTL_I;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_HSTL_I is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_HSTL_I",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_HSTL_I",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_HSTL_I",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_HSTL_I_VITAL of BIBUF_HSTL_I is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_HSTL_I_VITAL;



 ---- CELL BIBUF_LVCMOS15 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS15 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS15 :  entity is TRUE;
 end BIBUF_LVCMOS15;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_LVCMOS15 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS15",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS15",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS15",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS15_VITAL of BIBUF_LVCMOS15 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS15_VITAL;



 ---- CELL BIBUF_LVCMOS15D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS15D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS15D :  entity is TRUE;
 end BIBUF_LVCMOS15D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_LVCMOS15D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS15D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS15D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS15D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01LWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS15D_VITAL of BIBUF_LVCMOS15D is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS15D_VITAL;



 ---- CELL BIBUF_LVCMOS15U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS15U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS15U :  entity is TRUE;
 end BIBUF_LVCMOS15U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_LVCMOS15U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS15U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS15U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS15U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01HWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS15U_VITAL of BIBUF_LVCMOS15U is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS15U_VITAL;


 ---- CELL BIBUF_LVCMOS12 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS12 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS12 :  entity is TRUE;
 end BIBUF_LVCMOS12;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_LVCMOS12 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS12",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS12",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS12",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS12_VITAL of BIBUF_LVCMOS12 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS12_VITAL;



 ---- CELL BIBUF_LVCMOS12D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS12D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS12D :  entity is TRUE;
 end BIBUF_LVCMOS12D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_LVCMOS12D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS12D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS12D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS12D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01LWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS12D_VITAL of BIBUF_LVCMOS12D is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS12D_VITAL;



 ---- CELL BIBUF_LVCMOS12U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS12U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS12U :  entity is TRUE;
 end BIBUF_LVCMOS12U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_LVCMOS12U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS12U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS12U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS12U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01HWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS12U_VITAL of BIBUF_LVCMOS12U is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS12U_VITAL;



 ---- CELL BIBUF_LVCMOS18 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS18 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS18 :  entity is TRUE;
 end BIBUF_LVCMOS18;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_LVCMOS18 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS18",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS18",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS18",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS18_VITAL of BIBUF_LVCMOS18 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS18_VITAL;



 ---- CELL BIBUF_LVCMOS18D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS18D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS18D :  entity is TRUE;
 end BIBUF_LVCMOS18D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_LVCMOS18D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS18D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS18D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS18D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01LWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS18D_VITAL of BIBUF_LVCMOS18D is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS18D_VITAL;



 ---- CELL BIBUF_LVCMOS18U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS18U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS18U :  entity is TRUE;
 end BIBUF_LVCMOS18U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_LVCMOS18U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS18U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS18U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS18U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01HWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS18U_VITAL of BIBUF_LVCMOS18U is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS18U_VITAL;



 ---- CELL BIBUF_LVCMOS25 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS25 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS25 :  entity is TRUE;
 end BIBUF_LVCMOS25;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_LVCMOS25 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS25",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS25",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS25",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS25_VITAL of BIBUF_LVCMOS25 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS25_VITAL;



 ---- CELL BIBUF_LVCMOS25D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS25D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS25D :  entity is TRUE;
 end BIBUF_LVCMOS25D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_LVCMOS25D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS25D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS25D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS25D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01LWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS25D_VITAL of BIBUF_LVCMOS25D is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS25D_VITAL;



 ---- CELL BIBUF_LVCMOS25U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS25U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS25U :  entity is TRUE;
 end BIBUF_LVCMOS25U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;
use proasic3l.VTABLES.all;

architecture VITAL_ACT of BIBUF_LVCMOS25U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS25U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS25U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS25U",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event, tpd_E_PAD, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01HWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS25U_VITAL of BIBUF_LVCMOS25U is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS25U_VITAL;



 ---- CELL BIBUF_LVCMOS33 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS33 is
    generic(
                TimingChecksOn:Boolean := True;
                Xon: Boolean := False;
                InstancePath: STRING :="*";
                MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

                tpd_D_PAD               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
                tpd_PAD_Y               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                        tpd_D_Y                 : VitalDelayType01 := (0.100 ns, 0.100 ns);
                        tpd_E_Y                 : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tipd_D          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_E          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_PAD                : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                D               : in    STD_ULOGIC;
                E               : in    STD_ULOGIC;
                PAD             : inout STD_ULOGIC;
                Y               : out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS33 :  entity is TRUE;
 end BIBUF_LVCMOS33;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;

architecture VITAL_ACT of BIBUF_LVCMOS33 is
        attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

        SIGNAL D_ipd  : STD_ULOGIC := 'X';
        SIGNAL E_ipd  : STD_ULOGIC := 'X';
        SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

        ---------------------
        --  INPUT PATH DELAYs
        ---------------------
        WireDelay : block
        begin
        VitalWireDelay (D_ipd, D, tipd_D);
        VitalWireDelay (E_ipd, E, tipd_E);
        VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
        end block;

        --------------------
        --  BEHAVIOR SECTION
        --------------------
        VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



        -- functionality results
        VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
        ALIAS PAD_zd : STD_LOGIC is Results(1);
        ALIAS Y_zd : STD_LOGIC is Results(2);

        -- output glitch detection variables
        VARIABLE PAD_GlitchData  : VitalGlitchDataType;
        VARIABLE Y_GlitchData  : VitalGlitchDataType;

        begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS33",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS33",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS33",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


           -------------------------
           --  Functionality Section
           -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


           ----------------------
           --  Path Delay Section
           ----------------------

          VitalPathDelay01Z (
           OutSignal => PAD,
           GlitchData => PAD_GlitchData,
           OutSignalName => "PAD",
           OutTemp => PAD_zd,
           Paths => (
                     0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
                     1 => (E_ipd'last_event, tpd_E_PAD, true)),
          Mode => OnDetect,
          Xon => Xon,
          MsgOn => MsgOn,
          MsgSeverity => WARNING,
          OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
           OutSignal => Y,
           GlitchData => Y_GlitchData,
           OutSignalName => "Y",
           OutTemp => Y_zd,
           Paths => (
                     0 => (D_ipd'last_event,tpd_D_Y, true),
                     1 => (E_ipd'last_event,tpd_E_Y, true),
                     2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
          Mode => OnDetect,
          Xon => Xon,
          MsgOn => MsgOn,
          MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS33_VITAL of BIBUF_LVCMOS33 is
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS33_VITAL;



 ---- CELL BIBUF_LVCMOS33D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS33D is
    generic(
                TimingChecksOn:Boolean := True;
                Xon: Boolean := False;
                InstancePath: STRING :="*";
                MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;

                tpd_D_PAD               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_PAD : VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.1 ns, 0.1 ns, 0.1 ns, 0.1 ns);
                tpd_PAD_Y               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                        tpd_D_Y                 : VitalDelayType01 := (0.100 ns, 0.100 ns);
                        tpd_E_Y                 : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tipd_D          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_E          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_PAD                : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                D               : in    STD_ULOGIC;
                E               : in    STD_ULOGIC;
                PAD             : inout STD_ULOGIC;
                Y               : out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS33D :  entity is TRUE;
 end BIBUF_LVCMOS33D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library proasic3l;

architecture VITAL_ACT of BIBUF_LVCMOS33D is
        attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

        SIGNAL D_ipd  : STD_ULOGIC := 'X';
        SIGNAL E_ipd  : STD_ULOGIC := 'X';
        SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

        ---------------------
        --  INPUT PATH DELAYs
        ---------------------
        WireDelay : block
        begin
        VitalWireDelay (D_ipd, D, tipd_D);
        VitalWireDelay (E_ipd, E, tipd_E);
        VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
        end block;

        --------------------
        --  BEHAVIOR SECTION
        --------------------
        VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)

        -- timing check results
        VARIABLE Pviol_D        : STD_ULOGIC := '0';
        VARIABLE PeriodData_D   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_E        : STD_ULOGIC := '0';
        VARIABLE PeriodData_E   : VitalPeriodDataType := VitalPeriodDataInit;
        VARIABLE Pviol_PAD      : STD_ULOGIC := '0';
        VARIABLE PeriodData_PAD : VitalPeriodDataType := VitalPeriodDataInit;



        -- functionality results
        VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
        ALIAS PAD_zd : STD_LOGIC is Results(1);
        ALIAS Y_zd : STD_LOGIC is Results(2);

        -- output glitch detection variables
        VARIABLE PAD_GlitchData  : VitalGlitchDataType;
        VARIABLE Y_GlitchData  : VitalGlitchDataType;

        begin

        -- timing check results
        if( TimingChecksOn ) then

            VitalPeriodPulseCheck (
              Violation      => Pviol_PAD,
              PeriodData     => PeriodData_PAD,
              TestSignal     => PAD_ipd,
              TestSignalName => "PAD",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_PAD_posedge,
              PulseWidthLow  => tpw_PAD_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS33D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_D,
              PeriodData     => PeriodData_D,
              TestSignal     => D_ipd,
              TestSignalName => "D",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_D_posedge,
              PulseWidthLow  => tpw_D_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS33D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );


            VitalPeriodPulseCheck (
              Violation      => Pviol_E,
              PeriodData     => PeriodData_E,
              TestSignal     => E_ipd,
              TestSignalName => "E",
              TestDelay      => 0 ns,
              Period         => 0 ns,
              PulseWidthHigh => tpw_E_posedge,
              PulseWidthLow  => tpw_E_negedge,
              CheckEnabled   => TRUE,
              HeaderMsg      => InstancePath &"/BIBUF_LVCMOS33D",
              Xon            => Xon,
              MsgOn          => MsgOn,
              MsgSeverity    => WARNING
            );

        end if;


           -------------------------
           --  Functionality Section
           -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


           ----------------------
           --  Path Delay Section
           ----------------------

          VitalPathDelay01Z (
           OutSignal => PAD,
           GlitchData => PAD_GlitchData,
           OutSignalName => "PAD",
           OutTemp => PAD_zd,
           Paths => (
                     0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
                     1 => (E_ipd'last_event, tpd_E_PAD, true)),
          Mode => OnDetect,
          Xon => Xon,
          MsgOn => MsgOn,
          MsgSeverity => WARNING,
          OutputMap => "UX01LWLH-");

     VitalPathDelay01 (
           OutSignal => Y,
           GlitchData => Y_GlitchData,
           OutSignalName => "Y",
           OutTemp => Y_zd,
           Paths => (
                     0 => (D_ipd'last_event,tpd_D_Y, true),
                     1 => (E_ipd'last_event,tpd_E_Y, true),
                     2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
          Mode => OnDetect,
          Xon => Xon,
          MsgOn => MsgOn,
          MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS33D_VITAL of BIBUF_LVCMOS33D is
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS33D_VITAL;



 ---- CELL BIBUF_LVCMOS33U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS33U is
    generic(
                TimingChecksOn:Boolean := True;
                Xon: Boolean := False;
                InstancePath: STRING :="*";
                MsgOn: Boolean := True;

                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalD